/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.engine.metrics.ProcessEngineMetrics;
import io.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnDeferredRecordsBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.CatchEventBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.processing.variable.VariableBehavior;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.record.value.BpmnElementType;
import java.util.function.Function;

public final class BpmnBehaviorsImpl
implements BpmnBehaviors {
    private final ExpressionProcessor expressionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnDeferredRecordsBehavior deferredRecordsBehavior;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final TypedStreamWriter streamWriter;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;

    public BpmnBehaviorsImpl(ExpressionProcessor expressionBehavior, TypedStreamWriter streamWriter, TypedResponseWriter responseWriter, SideEffects sideEffects, MutableZeebeState zeebeState, CatchEventBehavior catchEventBehavior, VariableBehavior variableBehavior, Function<BpmnElementType, BpmnElementContainerProcessor<ExecutableFlowElement>> processorLookup, Writers writers) {
        StateWriter stateWriter = writers.state();
        TypedCommandWriter commandWriter = writers.command();
        this.streamWriter = streamWriter;
        this.expressionBehavior = expressionBehavior;
        this.stateBehavior = new BpmnStateBehavior(zeebeState, variableBehavior);
        this.stateTransitionGuard = new ProcessInstanceStateTransitionGuard(this.stateBehavior);
        this.variableMappingBehavior = new BpmnVariableMappingBehavior(expressionBehavior, zeebeState, variableBehavior);
        this.stateTransitionBehavior = new BpmnStateTransitionBehavior(streamWriter, zeebeState.getKeyGenerator(), this.stateBehavior, new ProcessEngineMetrics(zeebeState.getPartitionId()), this.stateTransitionGuard, processorLookup, writers);
        this.eventSubscriptionBehavior = new BpmnEventSubscriptionBehavior(this.stateBehavior, this.stateTransitionBehavior, catchEventBehavior, stateWriter, commandWriter, sideEffects, zeebeState);
        this.incidentBehavior = new BpmnIncidentBehavior(zeebeState, streamWriter);
        this.deferredRecordsBehavior = new BpmnDeferredRecordsBehavior(zeebeState);
        this.eventPublicationBehavior = new BpmnEventPublicationBehavior(zeebeState, streamWriter);
        this.processResultSenderBehavior = new BpmnProcessResultSenderBehavior(zeebeState, responseWriter);
        this.bufferedMessageStartEventBehavior = new BpmnBufferedMessageStartEventBehavior(zeebeState, streamWriter);
    }

    @Override
    public ExpressionProcessor expressionBehavior() {
        return this.expressionBehavior;
    }

    @Override
    public BpmnVariableMappingBehavior variableMappingBehavior() {
        return this.variableMappingBehavior;
    }

    @Override
    public BpmnEventPublicationBehavior eventPublicationBehavior() {
        return this.eventPublicationBehavior;
    }

    @Override
    public BpmnEventSubscriptionBehavior eventSubscriptionBehavior() {
        return this.eventSubscriptionBehavior;
    }

    @Override
    public BpmnIncidentBehavior incidentBehavior() {
        return this.incidentBehavior;
    }

    @Override
    public BpmnStateBehavior stateBehavior() {
        return this.stateBehavior;
    }

    @Override
    public TypedCommandWriter commandWriter() {
        return this.streamWriter;
    }

    @Override
    public BpmnStateTransitionBehavior stateTransitionBehavior() {
        return this.stateTransitionBehavior;
    }

    @Override
    public BpmnDeferredRecordsBehavior deferredRecordsBehavior() {
        return this.deferredRecordsBehavior;
    }

    @Override
    public ProcessInstanceStateTransitionGuard stateTransitionGuard() {
        return this.stateTransitionGuard;
    }

    @Override
    public BpmnProcessResultSenderBehavior processResultSenderBehavior() {
        return this.processResultSenderBehavior;
    }

    @Override
    public BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior() {
        return this.bufferedMessageStartEventBehavior;
    }
}

