/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.common.EventHandle;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.deployment.DeployedProcess;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.message.StoredMessage;
import io.zeebe.engine.state.mutable.MutableMessageState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class BpmnBufferedMessageStartEventBehavior {
    private final MutableMessageState messageState;
    private final ProcessState processState;
    private final TypedStreamWriter streamWriter;
    private final EventHandle eventHandle;

    public BpmnBufferedMessageStartEventBehavior(MutableZeebeState zeebeState, TypedStreamWriter streamWriter) {
        this.messageState = zeebeState.getMessageState();
        this.processState = zeebeState.getProcessState();
        this.streamWriter = streamWriter;
        this.eventHandle = new EventHandle(zeebeState.getKeyGenerator(), zeebeState.getEventScopeInstanceState());
    }

    public void correlateMessage(BpmnElementContext context) {
        long processInstanceKey = context.getProcessInstanceKey();
        DirectBuffer correlationKey = this.messageState.getProcessInstanceCorrelationKey(processInstanceKey);
        if (correlationKey != null) {
            this.messageState.removeProcessInstanceCorrelationKey(processInstanceKey);
            this.correlateNextBufferedMessage(correlationKey, context);
        }
    }

    private void correlateNextBufferedMessage(DirectBuffer correlationKey, BpmnElementContext context) {
        DirectBuffer bpmnProcessId = context.getBpmnProcessId();
        DeployedProcess process = this.processState.getLatestProcessVersionByProcessId(bpmnProcessId);
        this.findNextMessageToCorrelate(process, correlationKey).ifPresentOrElse(messageCorrelation -> {
            StoredMessage storedMessage = this.messageState.getMessage(messageCorrelation.messageKey);
            this.correlateMessage(process, messageCorrelation.elementId, storedMessage);
        }, () -> this.messageState.removeActiveProcessInstance(bpmnProcessId, correlationKey));
    }

    private Optional<Correlation> findNextMessageToCorrelate(DeployedProcess process, DirectBuffer correlationKey) {
        Correlation messageCorrelation = new Correlation();
        for (ExecutableStartEvent startEvent : process.getProcess().getStartEvents()) {
            if (!startEvent.isMessage()) continue;
            DirectBuffer messageNameBuffer = startEvent.getMessage().getMessageName().map(BufferUtil::wrapString).orElseThrow();
            this.messageState.visitMessages(messageNameBuffer, correlationKey, storedMessage -> {
                if (storedMessage.getMessage().getDeadline() > ActorClock.currentTimeMillis() && !this.messageState.existMessageCorrelation(storedMessage.getMessageKey(), process.getBpmnProcessId())) {
                    if (storedMessage.getMessageKey() < messageCorrelation.messageKey) {
                        messageCorrelation.messageKey = storedMessage.getMessageKey();
                        messageCorrelation.elementId = startEvent.getId();
                    }
                    return false;
                }
                return true;
            });
        }
        if (messageCorrelation.elementId != null) {
            return Optional.of(messageCorrelation);
        }
        return Optional.empty();
    }

    private void correlateMessage(DeployedProcess process, DirectBuffer elementId, StoredMessage storedMessage) {
        long processInstanceKey = this.eventHandle.triggerStartEvent(this.streamWriter, process.getKey(), elementId, storedMessage.getMessage().getVariablesBuffer());
        if (processInstanceKey > 0L) {
            this.messageState.putMessageCorrelation(storedMessage.getMessageKey(), process.getBpmnProcessId());
            this.messageState.putProcessInstanceCorrelationKey(processInstanceKey, storedMessage.getMessage().getCorrelationKeyBuffer());
        }
    }

    private static class Correlation {
        private long messageKey = Long.MAX_VALUE;
        private DirectBuffer elementId = null;

        private Correlation() {
        }
    }
}

