/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.engine.state.instance.StoredRecord;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import java.util.List;

public final class BpmnDeferredRecordsBehavior {
    private final MutableElementInstanceState elementInstanceState;

    public BpmnDeferredRecordsBehavior(MutableZeebeState zeebeState) {
        this.elementInstanceState = zeebeState.getElementInstanceState();
    }

    public void deferNewRecord(BpmnElementContext context, long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        this.elementInstanceState.storeRecord(key, context.getElementInstanceKey(), value, state, StoredRecord.Purpose.DEFERRED);
    }

    public List<IndexedRecord> getDeferredRecords(BpmnElementContext context) {
        return this.elementInstanceState.getDeferredRecords(context.getElementInstanceKey());
    }

    public void removeDeferredRecord(BpmnElementContext context, IndexedRecord deferredRecord) {
        this.elementInstanceState.removeStoredRecord(context.getElementInstanceKey(), deferredRecord.getKey(), StoredRecord.Purpose.DEFERRED);
    }
}

