/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.common.CatchEventBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.zeebe.engine.processing.deployment.model.element.ExecutableEventBasedGateway;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processing.deployment.model.element.ExecutableReceiveTask;
import io.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.processing.message.MessageCorrelationKeyException;
import io.zeebe.engine.processing.message.MessageNameException;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.deployment.DeployedProcess;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.EventTrigger;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.engine.state.instance.StoredRecord;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.protocol.record.value.ErrorType;
import io.zeebe.util.Either;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import java.util.function.ToLongFunction;
import org.agrona.DirectBuffer;

public final class BpmnEventSubscriptionBehavior {
    private static final String NO_PROCESS_FOUND_MESSAGE = "Expected to create an instance of process with key '%d', but no such process was found";
    private static final String NO_TRIGGERED_EVENT_MESSAGE = "Expected to create an instance of process with key '%d', but no triggered event could be found";
    private final ProcessInstanceRecord eventRecord = new ProcessInstanceRecord();
    private final ProcessInstanceRecord recordForWFICreation = new ProcessInstanceRecord();
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableElementInstanceState elementInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final StateWriter stateWriter;
    private final SideEffects sideEffects;
    private final KeyGenerator keyGenerator;
    private final ProcessState processState;
    private final MutableVariableState variablesState;
    private final TypedCommandWriter commandWriter;

    public BpmnEventSubscriptionBehavior(BpmnStateBehavior stateBehavior, BpmnStateTransitionBehavior stateTransitionBehavior, CatchEventBehavior catchEventBehavior, StateWriter stateWriter, TypedCommandWriter commandWriter, SideEffects sideEffects, MutableZeebeState zeebeState) {
        this.stateBehavior = stateBehavior;
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.catchEventBehavior = catchEventBehavior;
        this.stateWriter = stateWriter;
        this.commandWriter = commandWriter;
        this.sideEffects = sideEffects;
        this.processState = zeebeState.getProcessState();
        this.eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.keyGenerator = zeebeState.getKeyGenerator();
        this.variablesState = zeebeState.getVariableState();
    }

    public <T extends ExecutableCatchEventSupplier> Either<Failure, Void> subscribeToEvents(T element, BpmnElementContext context) {
        try {
            this.catchEventBehavior.subscribeToEvents(context, element, this.commandWriter, this.sideEffects);
            return Either.right(null);
        }
        catch (MessageCorrelationKeyException e) {
            return Either.left((Object)new Failure(e.getMessage(), ErrorType.EXTRACT_VALUE_ERROR, e.getVariableScopeKey()));
        }
        catch (ExpressionProcessor.EvaluationException e) {
            return Either.left((Object)new Failure(e.getMessage(), ErrorType.EXTRACT_VALUE_ERROR, context.getElementInstanceKey()));
        }
        catch (MessageNameException e) {
            return Either.left((Object)e.getFailure());
        }
    }

    public void unsubscribeFromEvents(BpmnElementContext context) {
        this.catchEventBehavior.unsubscribeFromEvents(context, this.commandWriter, this.sideEffects);
    }

    public void triggerBoundaryOrIntermediateEvent(ExecutableReceiveTask element, BpmnElementContext context) {
        this.triggerEvent(context, eventTrigger -> {
            boolean hasEventTriggeredForBoundaryEvent = element.getBoundaryEvents().stream().anyMatch(boundaryEvent -> boundaryEvent.getId().equals(eventTrigger.getElementId()));
            if (hasEventTriggeredForBoundaryEvent) {
                return this.triggerBoundaryEvent(element, context, (EventTrigger)((Object)eventTrigger));
            }
            this.stateTransitionBehavior.transitionToCompleting(context);
            return context.getElementInstanceKey();
        });
    }

    public void triggerIntermediateEvent(BpmnElementContext context) {
        this.triggerEvent(context, eventTrigger -> {
            this.stateTransitionBehavior.transitionToCompleting(context);
            return context.getElementInstanceKey();
        });
    }

    public void triggerBoundaryEvent(ExecutableActivity element, BpmnElementContext context) {
        this.triggerEvent(context, eventTrigger -> this.triggerBoundaryEvent(element, context, (EventTrigger)((Object)eventTrigger)));
    }

    private long triggerBoundaryEvent(ExecutableActivity element, BpmnElementContext context, EventTrigger eventTrigger) {
        ProcessInstanceRecord record = this.getEventRecord(context.getRecordValue(), eventTrigger, BpmnElementType.BOUNDARY_EVENT);
        ExecutableBoundaryEvent boundaryEvent = this.getBoundaryEvent(element, context, eventTrigger);
        long boundaryElementInstanceKey = this.keyGenerator.nextKey();
        if (boundaryEvent.interrupting()) {
            this.deferActivatingEvent(context, boundaryElementInstanceKey, record);
            this.stateTransitionBehavior.transitionToTerminating(context);
        } else {
            this.publishActivatingEvent(boundaryElementInstanceKey, record);
        }
        return boundaryElementInstanceKey;
    }

    private ProcessInstanceRecord getEventRecord(ProcessInstanceRecord value, EventTrigger event, BpmnElementType elementType) {
        this.eventRecord.reset();
        this.eventRecord.wrap(value);
        this.eventRecord.setElementId(event.getElementId());
        this.eventRecord.setBpmnElementType(elementType);
        return this.eventRecord;
    }

    private <T extends ExecutableActivity> ExecutableBoundaryEvent getBoundaryEvent(T element, BpmnElementContext context, EventTrigger eventTrigger) {
        return element.getBoundaryEvents().stream().filter(boundaryEvent -> boundaryEvent.getId().equals(eventTrigger.getElementId())).findFirst().orElseThrow(() -> new BpmnProcessingException(context, String.format("Expected boundary event with id '%s' but not found.", BufferUtil.bufferAsString((DirectBuffer)eventTrigger.getElementId()))));
    }

    private void deferActivatingEvent(BpmnElementContext context, long eventElementInstanceKey, ProcessInstanceRecord record) {
        this.elementInstanceState.storeRecord(eventElementInstanceKey, context.getElementInstanceKey(), record, ProcessInstanceIntent.ELEMENT_ACTIVATING, StoredRecord.Purpose.DEFERRED);
    }

    public void publishTriggeredBoundaryEvent(BpmnElementContext context) {
        this.publishTriggeredEvent(context, BpmnElementType.BOUNDARY_EVENT);
    }

    private void publishTriggeredEvent(BpmnElementContext context, BpmnElementType elementType) {
        this.elementInstanceState.getDeferredRecords(context.getElementInstanceKey()).stream().filter(record -> record.getValue().getBpmnElementType() == elementType).filter(record -> record.getState() == ProcessInstanceIntent.ELEMENT_ACTIVATING).findFirst().ifPresent(deferredRecord -> this.publishActivatingEvent(deferredRecord.getKey(), deferredRecord.getValue()));
    }

    private void publishActivatingEvent(long elementInstanceKey, ProcessInstanceRecord eventRecord) {
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)eventRecord);
    }

    public void triggerEventBasedGateway(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.triggerEvent(context, eventTrigger -> {
            ExecutableFlowNode triggeredEvent = this.getTriggeredEvent(element, context, (EventTrigger)((Object)eventTrigger));
            ProcessInstanceRecord record = this.getEventRecord(context.getRecordValue(), (EventTrigger)((Object)eventTrigger), triggeredEvent.getElementType());
            long eventElementInstanceKey = this.keyGenerator.nextKey();
            this.deferActivatingEvent(context, eventElementInstanceKey, record);
            this.stateTransitionBehavior.transitionToCompleting(context);
            return eventElementInstanceKey;
        });
    }

    private ExecutableFlowNode getTriggeredEvent(ExecutableEventBasedGateway element, BpmnElementContext context, EventTrigger eventTrigger) {
        return element.getOutgoing().stream().map(ExecutableSequenceFlow::getTarget).filter(target -> target.getId().equals(eventTrigger.getElementId())).findFirst().orElseThrow(() -> new BpmnProcessingException(context, String.format("Expected an event attached to the event-based gateway with id '%s' but not found.", BufferUtil.bufferAsString((DirectBuffer)eventTrigger.getElementId()))));
    }

    private void triggerEvent(BpmnElementContext context, ToLongFunction<EventTrigger> eventHandler) {
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(context.getElementInstanceKey());
        if (eventTrigger == null) {
            return;
        }
        long eventElementInstanceKey = eventHandler.applyAsLong(eventTrigger);
        DirectBuffer eventVariables = eventTrigger.getVariables();
        if (eventVariables != null && eventVariables.capacity() > 0) {
            this.variablesState.setTemporaryVariables(eventElementInstanceKey, eventVariables);
        }
        this.eventScopeInstanceState.deleteTrigger(context.getElementInstanceKey(), eventTrigger.getEventKey());
    }

    public void publishTriggeredEventBasedGateway(BpmnElementContext context) {
        this.publishTriggeredEvent(context, BpmnElementType.INTERMEDIATE_CATCH_EVENT);
    }

    public void triggerStartEvent(BpmnElementContext context) {
        long processDefinitionKey = context.getProcessDefinitionKey();
        long processInstanceKey = context.getProcessInstanceKey();
        DeployedProcess process = this.processState.getProcessByKey(context.getProcessDefinitionKey());
        if (process == null) {
            throw new BpmnProcessingException(context, String.format(NO_PROCESS_FOUND_MESSAGE, processDefinitionKey));
        }
        EventTrigger triggeredEvent = this.eventScopeInstanceState.peekEventTrigger(processDefinitionKey);
        if (triggeredEvent == null) {
            throw new BpmnProcessingException(context, String.format(NO_TRIGGERED_EVENT_MESSAGE, processDefinitionKey));
        }
        this.createProcessInstance(process, processInstanceKey);
        ProcessInstanceRecord record = this.getEventRecord(context.getRecordValue(), triggeredEvent, BpmnElementType.START_EVENT).setProcessInstanceKey(processInstanceKey).setVersion(process.getVersion()).setBpmnProcessId(process.getBpmnProcessId()).setFlowScopeKey(processInstanceKey);
        long newEventInstanceKey = this.keyGenerator.nextKey();
        this.elementInstanceState.storeRecord(newEventInstanceKey, processInstanceKey, record, ProcessInstanceIntent.ELEMENT_ACTIVATING, StoredRecord.Purpose.DEFERRED);
        this.variablesState.setTemporaryVariables(newEventInstanceKey, triggeredEvent.getVariables());
        this.eventScopeInstanceState.deleteTrigger(processDefinitionKey, triggeredEvent.getEventKey());
    }

    private void createProcessInstance(DeployedProcess process, long processInstanceKey) {
        this.recordForWFICreation.setBpmnProcessId(process.getBpmnProcessId()).setProcessDefinitionKey(process.getKey()).setVersion(process.getVersion()).setProcessInstanceKey(processInstanceKey).setElementId(process.getProcess().getId()).setBpmnElementType(process.getProcess().getElementType());
        this.stateWriter.appendFollowUpEvent(processInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)this.recordForWFICreation);
    }

    public boolean publishTriggeredStartEvent(BpmnElementContext context) {
        Optional<IndexedRecord> deferredStartEvent = this.elementInstanceState.getDeferredRecords(context.getElementInstanceKey()).stream().filter(record -> record.getValue().getBpmnElementType() == BpmnElementType.START_EVENT).filter(record -> record.getState() == ProcessInstanceIntent.ELEMENT_ACTIVATING).findFirst();
        deferredStartEvent.ifPresent(deferredRecord -> {
            long elementInstanceKey = deferredRecord.getKey();
            this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)deferredRecord.getValue());
        });
        return deferredStartEvent.isPresent();
    }

    public void triggerEventSubProcess(ExecutableStartEvent startEvent, BpmnElementContext context) {
        if (this.stateBehavior.getFlowScopeInstance(context).getInterruptingEventKey() > 0L) {
            return;
        }
        BpmnElementContext flowScopeContext = this.stateBehavior.getFlowScopeContext(context);
        this.triggerEvent(flowScopeContext, eventTrigger -> {
            DirectBuffer eventSubProcessElementId = startEvent.getEventSubProcess();
            ProcessInstanceRecord record = this.getEventRecord(context.getRecordValue(), (EventTrigger)((Object)eventTrigger), BpmnElementType.SUB_PROCESS).setElementId(eventSubProcessElementId);
            long eventElementInstanceKey = this.keyGenerator.nextKey();
            if (startEvent.interrupting()) {
                this.triggerInterruptingEventSubProcess(context, flowScopeContext, record, eventElementInstanceKey);
            } else {
                this.publishActivatingEvent(eventElementInstanceKey, record);
            }
            return eventElementInstanceKey;
        });
    }

    private void triggerInterruptingEventSubProcess(BpmnElementContext context, BpmnElementContext flowScopeContext, ProcessInstanceRecord eventRecord, long eventElementInstanceKey) {
        this.unsubscribeFromEvents(flowScopeContext);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(flowScopeContext);
        if (noActiveChildInstances) {
            this.publishActivatingEvent(eventElementInstanceKey, eventRecord);
        } else {
            this.deferActivatingEvent(flowScopeContext, eventElementInstanceKey, eventRecord);
        }
        this.stateBehavior.updateFlowScopeInstance(context, flowScopeInstance -> {
            flowScopeInstance.spawnToken();
            flowScopeInstance.setInterruptingEventKey(eventElementInstanceKey);
        });
    }

    public void publishTriggeredEventSubProcess(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        if (this.isInterrupted(elementInstance)) {
            this.elementInstanceState.getDeferredRecords(context.getElementInstanceKey()).stream().filter(record -> record.getKey() == elementInstance.getInterruptingEventKey()).filter(record -> record.getValue().getBpmnElementType() == BpmnElementType.SUB_PROCESS).findFirst().ifPresent(record -> {
                long elementInstanceKey = record.getKey();
                ProcessInstanceRecord interruptingRecord = record.getValue();
                this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)interruptingRecord);
            });
        }
    }

    private boolean isInterrupted(ElementInstance elementInstance) {
        return elementInstance.getNumberOfActiveTokens() == 2 && elementInstance.isInterrupted() && elementInstance.isActive();
    }
}

