/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.immutable.IncidentState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;

public final class BpmnIncidentBehavior {
    private final IncidentRecord incidentCommand = new IncidentRecord();
    private final IncidentState incidentState;
    private final TypedStreamWriter streamWriter;

    public BpmnIncidentBehavior(MutableZeebeState zeebeState, TypedStreamWriter streamWriter) {
        this.incidentState = zeebeState.getIncidentState();
        this.streamWriter = streamWriter;
    }

    public void resolveJobIncident(long jobKey) {
        boolean hasIncident;
        long incidentKey = this.incidentState.getJobIncidentKey(jobKey);
        boolean bl = hasIncident = incidentKey != -1L;
        if (hasIncident) {
            IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(incidentKey);
            this.streamWriter.appendFollowUpEvent(incidentKey, (Intent)IncidentIntent.RESOLVED, (RecordValue)incidentRecord);
        }
    }

    public void createIncident(Failure failure, BpmnElementContext context) {
        long variableScopeKey = failure.getVariableScopeKey() > 0L ? failure.getVariableScopeKey() : context.getElementInstanceKey();
        this.incidentCommand.reset();
        this.incidentCommand.setProcessInstanceKey(context.getProcessInstanceKey()).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setElementInstanceKey(context.getElementInstanceKey()).setElementId(context.getElementId()).setVariableScopeKey(variableScopeKey).setErrorType(failure.getErrorType()).setErrorMessage(failure.getMessage());
        this.streamWriter.appendNewCommand((Intent)IncidentIntent.CREATE, (RecordValue)this.incidentCommand);
    }

    public void resolveIncidents(BpmnElementContext context) {
        this.incidentState.forExistingProcessIncident(context.getElementInstanceKey(), (record, key) -> this.streamWriter.appendFollowUpEvent(key, (Intent)IncidentIntent.RESOLVED, (RecordValue)record));
    }
}

