/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.engine.metrics.ProcessEngineMetrics;
import io.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.ProcessInstanceLifecycle;
import io.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.deployment.DeployedProcess;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import java.util.List;
import java.util.function.Function;
import org.agrona.DirectBuffer;

public final class BpmnStateTransitionBehavior {
    private static final String NO_PROCESS_FOUND_MESSAGE = "Expected to find a deployed process for process id '%s', but none found.";
    private final TypedStreamWriter streamWriter;
    private final KeyGenerator keyGenerator;
    private final BpmnStateBehavior stateBehavior;
    private final Function<BpmnElementType, BpmnElementContainerProcessor<ExecutableFlowElement>> processorLookUp;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final ProcessEngineMetrics metrics;
    private final ProcessInstanceRecord childInstanceRecord = new ProcessInstanceRecord();
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;

    public BpmnStateTransitionBehavior(TypedStreamWriter streamWriter, KeyGenerator keyGenerator, BpmnStateBehavior stateBehavior, ProcessEngineMetrics metrics, ProcessInstanceStateTransitionGuard stateTransitionGuard, Function<BpmnElementType, BpmnElementContainerProcessor<ExecutableFlowElement>> processorLookUp, Writers writers) {
        this.streamWriter = streamWriter;
        this.keyGenerator = keyGenerator;
        this.stateBehavior = stateBehavior;
        this.metrics = metrics;
        this.stateTransitionGuard = stateTransitionGuard;
        this.processorLookUp = processorLookUp;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
    }

    public BpmnElementContext transitionToActivating(BpmnElementContext context) {
        ElementInstance elementInstance;
        if (MigratedStreamProcessors.isMigrated(context.getBpmnElementType()) && (elementInstance = this.stateBehavior.getElementInstance(context)) != null) {
            return context.copy(context.getElementInstanceKey(), context.getRecordValue(), ProcessInstanceIntent.ELEMENT_ACTIVATING);
        }
        return this.transitionTo(context, ProcessInstanceIntent.ELEMENT_ACTIVATING);
    }

    public BpmnElementContext transitionToActivated(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.stateTransitionGuard.registerStateTransition(context, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        }
        this.metrics.elementInstanceActivated(context.getBpmnElementType());
        return transitionedContext;
    }

    public BpmnElementContext transitionToCompleting(BpmnElementContext context) {
        ElementInstance elementInstance;
        if (MigratedStreamProcessors.isMigrated(context.getBpmnElementType()) && (elementInstance = this.stateBehavior.getElementInstance(context)).getState() == ProcessInstanceIntent.ELEMENT_COMPLETING) {
            return context.copy(context.getElementInstanceKey(), context.getRecordValue(), ProcessInstanceIntent.ELEMENT_COMPLETING);
        }
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_COMPLETING);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.stateTransitionGuard.registerStateTransition(context, ProcessInstanceIntent.ELEMENT_COMPLETING);
        }
        return transitionedContext;
    }

    public BpmnElementContext transitionToCompleted(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_COMPLETED);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.stateTransitionGuard.registerStateTransition(context, ProcessInstanceIntent.ELEMENT_COMPLETED);
        }
        this.metrics.elementInstanceCompleted(context.getBpmnElementType());
        return transitionedContext;
    }

    public BpmnElementContext transitionToTerminating(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_TERMINATING);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.stateTransitionGuard.registerStateTransition(context, ProcessInstanceIntent.ELEMENT_TERMINATING);
        }
        return transitionedContext;
    }

    public BpmnElementContext transitionToTerminated(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_TERMINATED);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.stateTransitionGuard.registerStateTransition(context, ProcessInstanceIntent.ELEMENT_TERMINATED);
        }
        this.metrics.elementInstanceTerminated(context.getBpmnElementType());
        return transitionedContext;
    }

    private BpmnElementContext transitionTo(BpmnElementContext context, ProcessInstanceIntent transition) {
        long key = context.getElementInstanceKey();
        ProcessInstanceRecord value = context.getRecordValue();
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.verifyTransition(context, transition);
            this.streamWriter.appendFollowUpEvent(key, (Intent)transition, (RecordValue)value);
        } else {
            this.stateWriter.appendFollowUpEvent(key, (Intent)transition, (RecordValue)value);
        }
        return context.copy(key, value, transition);
    }

    private void verifyTransition(BpmnElementContext context, ProcessInstanceIntent transition) {
        if (!ProcessInstanceLifecycle.canTransition(context.getIntent(), transition)) {
            throw new BpmnProcessingException(context, String.format("Expected to take transition to '%s' but element instance is in state '%s'.", transition, context.getIntent()));
        }
    }

    public void takeSequenceFlow(BpmnElementContext context, ExecutableSequenceFlow sequenceFlow) {
        this.verifyTransition(context, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN);
        ProcessInstanceRecord record = context.getRecordValue().setElementId(sequenceFlow.getId()).setBpmnElementType(sequenceFlow.getElementType());
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.streamWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, (RecordValue)record);
            this.stateBehavior.spawnToken(context);
        } else {
            this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, (RecordValue)record);
        }
    }

    public long activateChildInstance(BpmnElementContext context, ExecutableFlowElement childElement) {
        ProcessInstanceRecord childInstanceRecord = context.getRecordValue().setFlowScopeKey(context.getElementInstanceKey()).setElementId(childElement.getId()).setBpmnElementType(childElement.getElementType());
        long childInstanceKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(childInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)childInstanceRecord);
        return childInstanceKey;
    }

    public void activateElementInstanceInFlowScope(BpmnElementContext context, ExecutableFlowElement element) {
        ProcessInstanceRecord elementInstanceRecord = context.getRecordValue().setFlowScopeKey(context.getFlowScopeKey()).setElementId(element.getId()).setBpmnElementType(element.getElementType());
        long elementInstanceKey = this.keyGenerator.nextKey();
        if (MigratedStreamProcessors.isMigrated(element.getElementType())) {
            this.commandWriter.appendFollowUpCommand(elementInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)elementInstanceRecord);
        } else {
            this.streamWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)elementInstanceRecord);
            this.stateBehavior.createElementInstanceInFlowScope(context, elementInstanceKey, elementInstanceRecord);
        }
    }

    public boolean terminateChildInstances(BpmnElementContext context) {
        List<BpmnElementContext> childInstances = this.stateBehavior.getChildInstances(context);
        for (BpmnElementContext childInstanceContext : childInstances) {
            if (ProcessInstanceLifecycle.canTerminate(childInstanceContext.getIntent())) {
                if (!MigratedStreamProcessors.isMigrated(childInstanceContext.getBpmnElementType())) {
                    this.transitionToTerminating(childInstanceContext);
                    continue;
                }
                this.commandWriter.appendFollowUpCommand(childInstanceContext.getElementInstanceKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)childInstanceContext.getRecordValue());
                continue;
            }
            if (childInstanceContext.getIntent() != ProcessInstanceIntent.ELEMENT_COMPLETED) continue;
            this.stateBehavior.removeElementInstance(childInstanceContext);
        }
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        int activeChildInstances = elementInstance.getNumberOfActiveElementInstances();
        if (activeChildInstances > 0) {
            int pendingTokens = elementInstance.getNumberOfActiveTokens() - activeChildInstances;
            for (int t = 0; t < pendingTokens; ++t) {
                elementInstance.consumeToken();
            }
            this.stateBehavior.updateElementInstance(elementInstance);
        }
        return activeChildInstances == 0;
    }

    public <T extends ExecutableFlowNode> void takeOutgoingSequenceFlows(T element, BpmnElementContext context) {
        List<ExecutableSequenceFlow> outgoingSequenceFlows = element.getOutgoing();
        if (outgoingSequenceFlows.isEmpty()) {
            this.onElementCompleted(element, context);
        } else {
            outgoingSequenceFlows.forEach(sequenceFlow -> this.takeSequenceFlow(context, (ExecutableSequenceFlow)sequenceFlow));
        }
    }

    public void onElementCompleted(ExecutableFlowElement element, BpmnElementContext childContext) {
        BpmnElementContext containerContext;
        ExecutableFlowElement containerScope;
        ExecutableFlowElement flowScope = element.getFlowScope();
        if (flowScope != null) {
            containerScope = flowScope;
            containerContext = this.stateBehavior.getFlowScopeContext(childContext);
        } else {
            containerContext = this.stateBehavior.getParentElementInstanceContext(childContext);
            containerScope = this.getParentProcessScope(containerContext, childContext);
        }
        BpmnElementContainerProcessor<ExecutableFlowElement> containerProcessor = this.processorLookUp.apply(containerScope.getElementType());
        containerProcessor.onChildCompleted(containerScope, containerContext, childContext);
    }

    public void onElementTerminated(ExecutableFlowElement element, BpmnElementContext childContext) {
        ExecutableFlowElement containerScope;
        BpmnElementContext containerContext;
        ExecutableFlowElement flowScope = element.getFlowScope();
        if (flowScope != null) {
            containerContext = this.stateBehavior.getFlowScopeContext(childContext);
            containerScope = flowScope;
        } else {
            containerContext = this.stateBehavior.getParentElementInstanceContext(childContext);
            containerScope = this.getParentProcessScope(containerContext, childContext);
        }
        BpmnElementContainerProcessor<ExecutableFlowElement> containerProcessor = this.processorLookUp.apply(containerContext.getBpmnElementType());
        containerProcessor.onChildTerminated(containerScope, containerContext, childContext);
    }

    private ExecutableCallActivity getParentProcessScope(BpmnElementContext callActivityContext, BpmnElementContext childContext) {
        long processDefinitionKey = callActivityContext.getProcessDefinitionKey();
        DirectBuffer elementId = callActivityContext.getElementId();
        return this.stateBehavior.getProcess(processDefinitionKey).map(DeployedProcess::getProcess).map(process -> process.getElementById(elementId, BpmnElementType.CALL_ACTIVITY, ExecutableCallActivity.class)).orElseThrow(() -> new BpmnProcessingException(childContext, String.format(NO_PROCESS_FOUND_MESSAGE, processDefinitionKey)));
    }

    public long createChildProcessInstance(DeployedProcess process, BpmnElementContext context) {
        long processInstanceKey = this.keyGenerator.nextKey();
        this.childInstanceRecord.reset();
        this.childInstanceRecord.setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setProcessDefinitionKey(process.getKey()).setProcessInstanceKey(processInstanceKey).setParentProcessInstanceKey(context.getProcessInstanceKey()).setParentElementInstanceKey(context.getElementInstanceKey()).setElementId(process.getProcess().getId()).setBpmnElementType(process.getProcess().getElementType());
        this.streamWriter.appendFollowUpEvent(processInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)this.childInstanceRecord);
        this.stateBehavior.createElementInstance(processInstanceKey, this.childInstanceRecord);
        return processInstanceKey;
    }

    public void terminateChildProcessInstance(BpmnElementContext context) {
        this.stateBehavior.getCalledChildInstance(context).filter(ElementInstance::canTerminate).map(instance -> context.copy(instance.getKey(), instance.getValue(), instance.getState())).ifPresentOrElse(childInstanceContext -> this.transitionToTerminating((BpmnElementContext)childInstanceContext), () -> this.transitionToTerminated(context));
    }
}

