/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.behavior;

import io.zeebe.el.Expression;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processing.variable.VariableBehavior;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.util.Either;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class BpmnVariableMappingBehavior {
    private final ExpressionProcessor expressionProcessor;
    private final MutableVariableState variablesState;
    private final ElementInstanceState elementInstanceState;
    private final VariableBehavior variableBehavior;

    public BpmnVariableMappingBehavior(ExpressionProcessor expressionProcessor, MutableZeebeState zeebeState, VariableBehavior variableBehavior) {
        this.expressionProcessor = expressionProcessor;
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.variablesState = zeebeState.getVariableState();
        this.variableBehavior = variableBehavior;
    }

    public Either<Failure, Void> applyInputMappings(BpmnElementContext context, ExecutableFlowNode element) {
        long scopeKey = context.getElementInstanceKey();
        long processDefinitionKey = context.getProcessDefinitionKey();
        long processInstanceKey = context.getProcessInstanceKey();
        Optional<Expression> inputMappingExpression = element.getInputMappings();
        if (inputMappingExpression.isPresent()) {
            return this.expressionProcessor.evaluateVariableMappingExpression(inputMappingExpression.get(), scopeKey).map(result -> {
                this.variableBehavior.mergeLocalDocument(scopeKey, processDefinitionKey, processInstanceKey, (DirectBuffer)result);
                return null;
            });
        }
        return Either.right(null);
    }

    public Either<Failure, Void> applyOutputMappings(BpmnElementContext context, ExecutableFlowNode element) {
        ProcessInstanceRecord record = context.getRecordValue();
        long elementInstanceKey = context.getElementInstanceKey();
        long processDefinitionKey = record.getProcessDefinitionKey();
        long processInstanceKey = record.getProcessInstanceKey();
        Optional<Expression> outputMappingExpression = element.getOutputMappings();
        DirectBuffer temporaryVariables = this.variablesState.getTemporaryVariables(elementInstanceKey);
        if (temporaryVariables != null) {
            outputMappingExpression.ifPresentOrElse(expression -> this.variableBehavior.mergeLocalDocument(elementInstanceKey, processDefinitionKey, processInstanceKey, temporaryVariables), () -> this.variableBehavior.mergeDocument(elementInstanceKey, processDefinitionKey, processInstanceKey, temporaryVariables));
            this.variablesState.removeTemporaryVariables(elementInstanceKey);
        }
        if (outputMappingExpression.isPresent()) {
            long scopeKey = this.getVariableScopeKey(context);
            return this.expressionProcessor.evaluateVariableMappingExpression(outputMappingExpression.get(), elementInstanceKey).map(result -> {
                this.variableBehavior.mergeDocument(scopeKey, processDefinitionKey, processInstanceKey, (DirectBuffer)result);
                return null;
            });
        }
        return Either.right(null);
    }

    private long getVariableScopeKey(BpmnElementContext context) {
        long elementInstanceKey = context.getElementInstanceKey();
        boolean isMultiInstanceActivity = this.elementInstanceState.getInstance(elementInstanceKey).getMultiInstanceLoopCounter() > 0;
        return isMultiInstanceActivity ? elementInstanceKey : context.getFlowScopeKey();
    }
}

