/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.container;

import io.zeebe.el.Expression;
import io.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableLoopCharacteristics;
import io.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.msgpack.spec.MsgPackHelper;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.util.Either;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MultiInstanceBodyProcessor
implements BpmnElementContainerProcessor<ExecutableMultiInstanceBody> {
    private static final DirectBuffer NIL_VALUE = new UnsafeBuffer(MsgPackHelper.NIL);
    private static final DirectBuffer LOOP_COUNTER_VARIABLE = BufferUtil.wrapString((String)"loopCounter");
    private final MutableDirectBuffer loopCounterVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final DirectBuffer loopCounterVariableView = new UnsafeBuffer(0L, 0);
    private final MsgPackReader variableReader = new MsgPackReader();
    private final MsgPackWriter variableWriter = new MsgPackWriter();
    private final ExpandableArrayBuffer variableBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer resultBuffer = new UnsafeBuffer(0L, 0);
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public MultiInstanceBodyProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.expressionBehavior = bpmnBehaviors.expressionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableMultiInstanceBody> getType() {
        return ExecutableMultiInstanceBody.class;
    }

    @Override
    public void onActivating(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.readInputCollectionVariable(element, context).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Either<Failure, List<DirectBuffer>> inputCollectionOrFailure = this.readInputCollectionVariable(element, context);
        if (inputCollectionOrFailure.isLeft()) {
            this.incidentBehavior.createIncident((Failure)inputCollectionOrFailure.getLeft(), context);
            return;
        }
        List inputCollection = (List)inputCollectionOrFailure.get();
        ExecutableLoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        loopCharacteristics.getOutputCollection().ifPresent(variableName -> this.initializeOutputCollection(context, (DirectBuffer)variableName, inputCollection.size()));
        if (inputCollection.isEmpty()) {
            this.stateTransitionBehavior.transitionToCompleting(context);
            return;
        }
        if (loopCharacteristics.isSequential()) {
            DirectBuffer firstItem = (DirectBuffer)inputCollection.get(0);
            this.createInnerInstance(element, context, firstItem);
        } else {
            inputCollection.forEach(item -> this.createInnerInstance(element, context, (DirectBuffer)item));
        }
    }

    @Override
    public void onCompleting(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        element.getLoopCharacteristics().getOutputCollection().ifPresent(variableName -> this.stateBehavior.propagateVariable(context, (DirectBuffer)variableName));
        this.stateTransitionBehavior.transitionToCompleted(context);
    }

    @Override
    public void onCompleted(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.stateTransitionBehavior.transitionToTerminated(context);
        }
    }

    @Override
    public void onTerminated(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.publishTriggeredBoundaryEvent(context);
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.triggerBoundaryEvent(element, context);
    }

    @Override
    public void onChildCompleted(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        Either<Failure, Void> updatedOrFailure = this.updateOutputCollection(element, childContext, flowScopeContext);
        if (updatedOrFailure.isLeft()) {
            this.incidentBehavior.createIncident((Failure)updatedOrFailure.getLeft(), childContext);
            return;
        }
        ExecutableLoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        if (loopCharacteristics.isSequential()) {
            Either<Failure, List<DirectBuffer>> inputCollectionOrFailure = this.readInputCollectionVariable(element, childContext);
            if (inputCollectionOrFailure.isLeft()) {
                this.incidentBehavior.createIncident((Failure)inputCollectionOrFailure.getLeft(), childContext);
                return;
            }
            List inputCollection = (List)inputCollectionOrFailure.get();
            int loopCounter = this.stateBehavior.getFlowScopeInstance(childContext).getMultiInstanceLoopCounter();
            if (loopCounter < inputCollection.size()) {
                DirectBuffer item = (DirectBuffer)inputCollection.get(loopCounter);
                this.createInnerInstance(element, flowScopeContext, item);
            }
        }
        if (this.stateBehavior.isLastActiveExecutionPathInScope(childContext)) {
            this.stateTransitionBehavior.transitionToCompleting(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (flowScopeContext.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING && this.stateBehavior.isLastActiveExecutionPathInScope(childContext)) {
            this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
        } else {
            this.eventSubscriptionBehavior.publishTriggeredEventSubProcess(flowScopeContext);
        }
    }

    private Either<Failure, List<DirectBuffer>> readInputCollectionVariable(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Expression inputCollection = element.getLoopCharacteristics().getInputCollection();
        return this.expressionBehavior.evaluateArrayExpression(inputCollection, context.getElementInstanceKey());
    }

    private void createInnerInstance(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext context, DirectBuffer item) {
        long innerInstanceKey = this.stateTransitionBehavior.activateChildInstance(context, multiInstanceBody.getInnerActivity());
        ElementInstance innerInstance = this.stateBehavior.getElementInstance(innerInstanceKey);
        BpmnElementContext innerInstanceContext = context.copy(innerInstanceKey, innerInstance.getValue(), innerInstance.getState());
        ElementInstance bodyInstance = this.stateBehavior.getElementInstance(context);
        bodyInstance.incrementMultiInstanceLoopCounter();
        this.stateBehavior.updateElementInstance(bodyInstance);
        innerInstance.setMultiInstanceLoopCounter(bodyInstance.getMultiInstanceLoopCounter());
        this.stateBehavior.updateElementInstance(innerInstance);
        ExecutableLoopCharacteristics loopCharacteristics = multiInstanceBody.getLoopCharacteristics();
        loopCharacteristics.getInputElement().ifPresent(variableName -> this.stateBehavior.setLocalVariable(innerInstanceContext, (DirectBuffer)variableName, item));
        loopCharacteristics.getOutputElement().flatMap(Expression::getVariableName).map(BufferUtil::wrapString).ifPresent(variableName -> this.stateBehavior.setLocalVariable(innerInstanceContext, (DirectBuffer)variableName, NIL_VALUE));
        this.stateBehavior.setLocalVariable(innerInstanceContext, LOOP_COUNTER_VARIABLE, this.wrapLoopCounter(innerInstance.getMultiInstanceLoopCounter()));
    }

    private DirectBuffer wrapLoopCounter(int loopCounter) {
        this.variableWriter.wrap(this.loopCounterVariableBuffer, 0);
        this.variableWriter.writeInteger((long)loopCounter);
        int length = this.variableWriter.getOffset();
        this.loopCounterVariableView.wrap((DirectBuffer)this.loopCounterVariableBuffer, 0, length);
        return this.loopCounterVariableView;
    }

    private void initializeOutputCollection(BpmnElementContext context, DirectBuffer variableName, int size) {
        this.variableWriter.wrap((MutableDirectBuffer)this.variableBuffer, 0);
        this.variableWriter.writeArrayHeader(size);
        for (int i = 0; i < size; ++i) {
            this.variableWriter.writeNil();
        }
        int length = this.variableWriter.getOffset();
        this.stateBehavior.setLocalVariable(context, variableName, (DirectBuffer)this.variableBuffer, 0, length);
    }

    private Either<Failure, Void> updateOutputCollection(ExecutableMultiInstanceBody element, BpmnElementContext childContext, BpmnElementContext flowScopeContext) {
        return element.getLoopCharacteristics().getOutputCollection().map(variableName -> this.updateOutputCollection(element, childContext, flowScopeContext, (DirectBuffer)variableName)).orElse(Either.right(null));
    }

    private Either<Failure, Void> updateOutputCollection(ExecutableMultiInstanceBody element, BpmnElementContext childContext, BpmnElementContext flowScopeContext, DirectBuffer variableName) {
        int loopCounter = this.stateBehavior.getElementInstance(childContext).getMultiInstanceLoopCounter();
        return this.readOutputElementVariable(element, childContext).map(elementVariable -> {
            DirectBuffer currentCollection = this.stateBehavior.getLocalVariable(flowScopeContext, variableName);
            DirectBuffer updatedCollection = this.insertAt(currentCollection, loopCounter, (DirectBuffer)elementVariable);
            this.stateBehavior.setLocalVariable(flowScopeContext, variableName, updatedCollection);
            return null;
        });
    }

    private Either<Failure, DirectBuffer> readOutputElementVariable(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Expression expression = element.getLoopCharacteristics().getOutputElement().orElseThrow();
        return this.expressionBehavior.evaluateAnyExpression(expression, context.getElementInstanceKey());
    }

    private DirectBuffer insertAt(DirectBuffer array, int index, DirectBuffer element) {
        this.variableReader.wrap(array, 0, array.capacity());
        this.variableReader.readArrayHeader();
        this.variableReader.skipValues((long)index - 1L);
        int offsetBefore = this.variableReader.getOffset();
        this.variableReader.skipValue();
        int offsetAfter = this.variableReader.getOffset();
        this.variableWriter.wrap((MutableDirectBuffer)this.variableBuffer, 0);
        this.variableWriter.writeRaw(array, 0, offsetBefore);
        this.variableWriter.writeRaw(element);
        this.variableWriter.writeRaw(array, offsetAfter, array.capacity() - offsetAfter);
        int length = this.variableWriter.getOffset();
        this.resultBuffer.wrap((DirectBuffer)this.variableBuffer, 0, length);
        return this.resultBuffer;
    }
}

