/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.container;

import io.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;

public final class ProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;

    public ProcessProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.processResultSenderBehavior = bpmnBehaviors.processResultSenderBehavior();
        this.bufferedMessageStartEventBehavior = bpmnBehaviors.bufferedMessageStartEventBehavior();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public void onActivating(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.subscribeToEvents(element, context).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableFlowElementContainer element, BpmnElementContext context) {
        boolean triggeredByEvent = false;
        if (element.hasMessageStartEvent() || element.hasTimerStartEvent()) {
            triggeredByEvent = this.eventSubscriptionBehavior.publishTriggeredStartEvent(context);
        }
        if (!triggeredByEvent) {
            ExecutableStartEvent noneStartEvent = element.getNoneStartEvent();
            if (noneStartEvent == null) {
                throw new BpmnProcessingException(context, "Expected to activate the none start event of the process but not found.");
            }
            this.stateTransitionBehavior.activateChildInstance(context, noneStartEvent);
        }
    }

    @Override
    public void onCompleting(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.stateTransitionBehavior.transitionToCompleted(context);
    }

    @Override
    public void onCompleted(ExecutableFlowElementContainer element, BpmnElementContext context) {
        long parentProcessInstanceKey = context.getParentProcessInstanceKey();
        if (parentProcessInstanceKey > 0L) {
            this.stateTransitionBehavior.onElementCompleted(element, context);
        }
        if (element.hasNoneStartEvent()) {
            this.processResultSenderBehavior.sendResult(context);
        }
        if (element.hasMessageStartEvent()) {
            this.bufferedMessageStartEventBehavior.correlateMessage(context);
        }
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.stateTransitionBehavior.transitionToTerminated(context);
        }
    }

    @Override
    public void onTerminated(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        long parentProcessInstanceKey = context.getParentProcessInstanceKey();
        if (parentProcessInstanceKey > 0L) {
            this.stateTransitionBehavior.onElementTerminated(element, context);
        }
        if (element.hasMessageStartEvent()) {
            this.bufferedMessageStartEventBehavior.correlateMessage(context);
        }
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableFlowElementContainer element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, "Expected to handle occurred event on process, but events should not occur on process.");
    }

    @Override
    public void onChildCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (this.stateBehavior.isLastActiveExecutionPathInScope(childContext)) {
            this.stateTransitionBehavior.transitionToCompleting(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (flowScopeContext.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING && this.stateBehavior.isLastActiveExecutionPathInScope(childContext)) {
            this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
        } else {
            this.eventSubscriptionBehavior.publishTriggeredEventSubProcess(flowScopeContext);
        }
    }
}

