/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.container;

import io.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;

public final class SubProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public SubProcessProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public void onActivating(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableFlowElementContainer element, BpmnElementContext context) {
        ExecutableStartEvent startEvent = element.hasNoneStartEvent() ? element.getNoneStartEvent() : element.getStartEvents().get(0);
        this.stateTransitionBehavior.activateChildInstance(context, startEvent);
    }

    @Override
    public void onCompleting(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).ifRightOrLeft(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            this.stateTransitionBehavior.transitionToCompleted(context);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleted(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.stateTransitionBehavior.transitionToTerminated(context);
        }
    }

    @Override
    public void onTerminated(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.publishTriggeredBoundaryEvent(context);
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.triggerBoundaryEvent(element, context);
    }

    @Override
    public void onChildCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (this.stateBehavior.isLastActiveExecutionPathInScope(childContext)) {
            this.stateTransitionBehavior.transitionToCompleting(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (flowScopeContext.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING && this.stateBehavior.isLastActiveExecutionPathInScope(childContext)) {
            this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
        } else {
            this.eventSubscriptionBehavior.publishTriggeredEventSubProcess(flowScopeContext);
        }
    }
}

