/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.event;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;

public final class BoundaryEventProcessor
implements BpmnElementProcessor<ExecutableBoundaryEvent> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public BoundaryEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableBoundaryEvent> getType() {
        return ExecutableBoundaryEvent.class;
    }

    @Override
    public void onActivating(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToActivated(context);
    }

    @Override
    public void onActivated(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToCompleting(context);
    }

    @Override
    public void onCompleting(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToCompleted(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleted(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.onElementTerminated(element, context);
    }

    @Override
    public void onTerminated(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableBoundaryEvent element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, "Expected to handle occurred event on a boundary event, but events should not occur on a boundary event.");
    }
}

