/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.event;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.zeebe.protocol.record.value.ErrorType;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class EndEventProcessor
implements BpmnElementProcessor<ExecutableEndEvent> {
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;

    public EndEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
    }

    @Override
    public Class<ExecutableEndEvent> getType() {
        return ExecutableEndEvent.class;
    }

    @Override
    public void onActivating(ExecutableEndEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToActivated(context);
    }

    @Override
    public void onActivated(ExecutableEndEvent element, BpmnElementContext context) {
        if (!element.hasError()) {
            this.stateTransitionBehavior.transitionToCompleting(context);
            return;
        }
        ExecutableError error = element.getError();
        EnsureUtil.ensureNotNull((String)"error", (Object)error);
        DirectBuffer errorCode = error.getErrorCode();
        EnsureUtil.ensureNotNullOrEmpty((String)"errorCode", (DirectBuffer)errorCode);
        boolean errorThrownAndCaught = this.eventPublicationBehavior.throwErrorEvent(errorCode, context);
        if (!errorThrownAndCaught) {
            String errorMessage = String.format("Expected to throw an error event with the code '%s', but it was not caught.", BufferUtil.bufferAsString((DirectBuffer)errorCode));
            Failure failure = new Failure(errorMessage, ErrorType.UNHANDLED_ERROR_EVENT);
            this.incidentBehavior.createIncident(failure, context);
        }
    }

    @Override
    public void onCompleting(ExecutableEndEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToCompleted(context);
    }

    @Override
    public void onCompleted(ExecutableEndEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.onElementCompleted(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableEndEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToTerminated(context);
    }

    @Override
    public void onTerminated(ExecutableEndEvent element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableEndEvent element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, "Expected to handle occurred event on end event element, but events should not occur on end event element.");
    }
}

