/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.event;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;

public class IntermediateCatchEventProcessor
implements BpmnElementProcessor<ExecutableCatchEventElement> {
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;

    public IntermediateCatchEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
    }

    @Override
    public Class<ExecutableCatchEventElement> getType() {
        return ExecutableCatchEventElement.class;
    }

    @Override
    public void onActivating(ExecutableCatchEventElement element, BpmnElementContext context) {
        if (element.isConnectedToEventBasedGateway()) {
            this.stateTransitionBehavior.transitionToActivated(context);
            return;
        }
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableCatchEventElement element, BpmnElementContext context) {
        if (element.isConnectedToEventBasedGateway()) {
            this.stateTransitionBehavior.transitionToCompleting(context);
        }
    }

    @Override
    public void onCompleting(ExecutableCatchEventElement element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).ifRightOrLeft(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            this.stateTransitionBehavior.transitionToCompleted(context);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleted(ExecutableCatchEventElement element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableCatchEventElement element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.stateTransitionBehavior.transitionToTerminated(context);
    }

    @Override
    public void onTerminated(ExecutableCatchEventElement element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableCatchEventElement element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.triggerIntermediateEvent(context);
    }
}

