/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.event;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;

public class StartEventProcessor
implements BpmnElementProcessor<ExecutableStartEvent> {
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;

    public StartEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
    }

    @Override
    public Class<ExecutableStartEvent> getType() {
        return ExecutableStartEvent.class;
    }

    @Override
    public void onActivating(ExecutableStartEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToActivated(context);
    }

    @Override
    public void onActivated(ExecutableStartEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToCompleting(context);
    }

    @Override
    public void onCompleting(ExecutableStartEvent element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToCompleted(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleted(ExecutableStartEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableStartEvent element, BpmnElementContext context) {
        this.stateTransitionBehavior.transitionToTerminated(context);
    }

    @Override
    public void onTerminated(ExecutableStartEvent element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableStartEvent element, BpmnElementContext context) {
        if (element.getEventSubProcess() != null) {
            this.eventSubscriptionBehavior.triggerEventSubProcess(element, context);
        } else {
            this.eventSubscriptionBehavior.triggerStartEvent(context);
        }
    }
}

