/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.gateway;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableEventBasedGateway;

public final class EventBasedGatewayProcessor
implements BpmnElementProcessor<ExecutableEventBasedGateway> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public EventBasedGatewayProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableEventBasedGateway> getType() {
        return ExecutableEventBasedGateway.class;
    }

    @Override
    public void onActivating(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.subscribeToEvents(element, context).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableEventBasedGateway element, BpmnElementContext context) {
    }

    @Override
    public void onCompleting(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.stateTransitionBehavior.transitionToCompleted(context);
    }

    @Override
    public void onCompleted(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.publishTriggeredEventBasedGateway(context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.stateTransitionBehavior.transitionToTerminated(context);
    }

    @Override
    public void onTerminated(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.triggerEventBasedGateway(element, context);
    }
}

