/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.gateway;

import io.zeebe.el.Expression;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableExclusiveGateway;
import io.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.ErrorType;
import io.zeebe.util.Either;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ExclusiveGatewayProcessor
implements BpmnElementProcessor<ExecutableExclusiveGateway> {
    private static final String NO_OUTGOING_FLOW_CHOSEN_ERROR = "Expected at least one condition to evaluate to true, or to have a default flow";
    private static final String TRANSITION_TO_COMPLETED_PRECONDITION_ERROR = "Expected to transition element to completed, but state is not ELEMENT_ACTIVATING";
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final ExpressionProcessor expressionBehavior;

    public ExclusiveGatewayProcessor(BpmnBehaviors behaviors) {
        this.expressionBehavior = behaviors.expressionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateTransitionBehavior = behaviors.stateTransitionBehavior();
    }

    @Override
    public Class<ExecutableExclusiveGateway> getType() {
        return ExecutableExclusiveGateway.class;
    }

    @Override
    public void onActivate(ExecutableExclusiveGateway element, BpmnElementContext activating) {
        if (element.getOutgoing().isEmpty()) {
            BpmnElementContext completed = this.transitionToCompleted(activating);
            this.stateTransitionBehavior.onElementCompleted(element, completed);
        } else {
            this.findSequenceFlowToTake(element, activating).ifRightOrLeft(sequenceFlow -> {
                BpmnElementContext completed = this.transitionToCompleted(activating);
                this.stateTransitionBehavior.takeSequenceFlow(completed, (ExecutableSequenceFlow)sequenceFlow);
            }, failure -> this.incidentBehavior.createIncident((Failure)failure, activating));
        }
    }

    @Override
    public void onComplete(ExecutableExclusiveGateway element, BpmnElementContext context) {
        throw new UnsupportedOperationException(String.format("Expected to explicitly process complete, but gateway %s has no wait state", BufferUtil.bufferAsString((DirectBuffer)context.getElementId())));
    }

    @Override
    public void onTerminate(ExecutableExclusiveGateway element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    @Override
    public void onEventOccurred(ExecutableExclusiveGateway element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, "Expected to handle occurred event on exclusive gateway, but events should not occur on exclusive gateway.");
    }

    private BpmnElementContext transitionToCompleted(BpmnElementContext activating) {
        if (activating.getIntent() != ProcessInstanceIntent.ELEMENT_ACTIVATING) {
            throw new BpmnProcessingException(activating, TRANSITION_TO_COMPLETED_PRECONDITION_ERROR);
        }
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(activating);
        BpmnElementContext completing = this.stateTransitionBehavior.transitionToCompleting(activated);
        return this.stateTransitionBehavior.transitionToCompleted(completing);
    }

    private Either<Failure, ExecutableSequenceFlow> findSequenceFlowToTake(ExecutableExclusiveGateway element, BpmnElementContext context) {
        if (element.getOutgoing().size() == 1 && element.getOutgoing().get(0).getCondition() == null) {
            return Either.right((Object)element.getOutgoing().get(0));
        }
        for (ExecutableSequenceFlow sequenceFlow : element.getOutgoingWithCondition()) {
            Expression condition = sequenceFlow.getCondition();
            Either<Failure, Boolean> isFulfilledOrFailure = this.expressionBehavior.evaluateBooleanExpression(condition, context.getElementInstanceKey());
            if (isFulfilledOrFailure.isLeft()) {
                return Either.left((Object)((Failure)isFulfilledOrFailure.getLeft()));
            }
            if (!((Boolean)isFulfilledOrFailure.get()).booleanValue()) continue;
            return Either.right((Object)sequenceFlow);
        }
        if (element.getDefaultFlow() != null) {
            return Either.right((Object)element.getDefaultFlow());
        }
        return Either.left((Object)new Failure(NO_OUTGOING_FLOW_CHOSEN_ERROR, ErrorType.CONDITION_ERROR, context.getElementInstanceKey()));
    }
}

