/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.gateway;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ParallelGatewayProcessor
implements BpmnElementProcessor<ExecutableFlowNode> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;

    public ParallelGatewayProcessor(BpmnBehaviors behaviors) {
        this.stateTransitionBehavior = behaviors.stateTransitionBehavior();
    }

    @Override
    public Class<ExecutableFlowNode> getType() {
        return ExecutableFlowNode.class;
    }

    @Override
    public void onActivate(ExecutableFlowNode element, BpmnElementContext context) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
        BpmnElementContext completing = this.stateTransitionBehavior.transitionToCompleting(activated);
        BpmnElementContext completed = this.stateTransitionBehavior.transitionToCompleted(completing);
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, completed);
    }

    @Override
    public void onComplete(ExecutableFlowNode element, BpmnElementContext context) {
        throw new UnsupportedOperationException(String.format("Expected to explicitly process complete, but gateway %s has already been completed on processing activate", BufferUtil.bufferAsString((DirectBuffer)context.getElementId())));
    }

    @Override
    public void onTerminate(ExecutableFlowNode element, BpmnElementContext context) {
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    @Override
    public void onEventOccurred(ExecutableFlowNode element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, "Expected to handle occurred event on a parallel gateway, but events should not occur on a parallel gateway.");
    }
}

