/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.sequenceflow;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnDeferredRecordsBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class SequenceFlowProcessor
implements BpmnElementProcessor<ExecutableSequenceFlow> {
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "This is not the method you're looking for.";
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnDeferredRecordsBehavior deferredRecordsBehavior;

    public SequenceFlowProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.deferredRecordsBehavior = bpmnBehaviors.deferredRecordsBehavior();
    }

    @Override
    public Class<ExecutableSequenceFlow> getType() {
        return ExecutableSequenceFlow.class;
    }

    @Override
    public void onActivating(ExecutableSequenceFlow element, BpmnElementContext context) {
        this.onSequenceFlowTaken(element, context);
    }

    @Override
    public void onActivated(ExecutableSequenceFlow element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void onCompleting(ExecutableSequenceFlow element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void onCompleted(ExecutableSequenceFlow element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void onTerminating(ExecutableSequenceFlow element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void onTerminated(ExecutableSequenceFlow element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void onEventOccurred(ExecutableSequenceFlow element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, UNSUPPORTED_OPERATION_MESSAGE);
    }

    private void onSequenceFlowTaken(ExecutableSequenceFlow element, BpmnElementContext context) {
        ExecutableFlowNode targetElement = element.getTarget();
        if (targetElement.getElementType() == BpmnElementType.PARALLEL_GATEWAY) {
            this.joinOnParallelGateway(targetElement, context);
        } else {
            this.stateTransitionBehavior.activateElementInstanceInFlowScope(context, targetElement);
        }
    }

    private void joinOnParallelGateway(ExecutableFlowNode parallelGateway, BpmnElementContext context) {
        BpmnElementContext flowScopeContext = this.stateBehavior.getFlowScopeContext(context);
        this.deferredRecordsBehavior.deferNewRecord(flowScopeContext, context.getElementInstanceKey(), context.getRecordValue(), context.getIntent());
        Map<DirectBuffer, List<IndexedRecord>> tokensBySequenceFlow = this.deferredRecordsBehavior.getDeferredRecords(flowScopeContext).stream().filter(record -> record.getState() == ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN).filter(record -> this.isIncomingSequenceFlow((IndexedRecord)((Object)record), parallelGateway)).collect(Collectors.groupingBy(record -> record.getValue().getElementIdBuffer()));
        if (tokensBySequenceFlow.size() == parallelGateway.getIncoming().size()) {
            ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
            tokensBySequenceFlow.forEach((sequenceFlow, tokens) -> {
                IndexedRecord firstToken = (IndexedRecord)((Object)((Object)tokens.get(0)));
                this.deferredRecordsBehavior.removeDeferredRecord(flowScopeContext, firstToken);
                flowScopeInstance.consumeToken();
            });
            flowScopeInstance.spawnToken();
            this.stateBehavior.updateElementInstance(flowScopeInstance);
            this.stateTransitionBehavior.activateElementInstanceInFlowScope(context, parallelGateway);
        }
    }

    private boolean isIncomingSequenceFlow(IndexedRecord record, ExecutableFlowNode parallelGateway) {
        DirectBuffer elementId = record.getValue().getElementIdBuffer();
        for (ExecutableSequenceFlow incomingSequenceFlow : parallelGateway.getIncoming()) {
            if (!elementId.equals(incomingSequenceFlow.getId())) continue;
            return true;
        }
        return false;
    }
}

