/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.task;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableReceiveTask;

public final class ReceiveTaskProcessor
implements BpmnElementProcessor<ExecutableReceiveTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;

    public ReceiveTaskProcessor(BpmnBehaviors behaviors) {
        this.eventSubscriptionBehavior = behaviors.eventSubscriptionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateBehavior = behaviors.stateBehavior();
        this.stateTransitionBehavior = behaviors.stateTransitionBehavior();
        this.variableMappingBehavior = behaviors.variableMappingBehavior();
    }

    @Override
    public Class<ExecutableReceiveTask> getType() {
        return ExecutableReceiveTask.class;
    }

    @Override
    public void onActivating(ExecutableReceiveTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableReceiveTask element, BpmnElementContext context) {
    }

    @Override
    public void onCompleting(ExecutableReceiveTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).ifRightOrLeft(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            this.stateTransitionBehavior.transitionToCompleted(context);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleted(ExecutableReceiveTask element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableReceiveTask element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.stateTransitionBehavior.transitionToTerminated(context);
    }

    @Override
    public void onTerminated(ExecutableReceiveTask element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.publishTriggeredBoundaryEvent(context);
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableReceiveTask element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.triggerBoundaryOrIntermediateEvent(element, context);
    }
}

