/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn.task;

import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableServiceTask;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.msgpack.value.DocumentValue;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.util.Either;

public final class ServiceTaskProcessor
implements BpmnElementProcessor<ExecutableServiceTask> {
    private final JobRecord jobCommand = new JobRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final ExpressionProcessor expressionBehavior;
    private final TypedCommandWriter commandWriter;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;

    public ServiceTaskProcessor(BpmnBehaviors behaviors) {
        this.eventSubscriptionBehavior = behaviors.eventSubscriptionBehavior();
        this.expressionBehavior = behaviors.expressionBehavior();
        this.commandWriter = behaviors.commandWriter();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateBehavior = behaviors.stateBehavior();
        this.stateTransitionBehavior = behaviors.stateTransitionBehavior();
        this.variableMappingBehavior = behaviors.variableMappingBehavior();
    }

    @Override
    public Class<ExecutableServiceTask> getType() {
        return ExecutableServiceTask.class;
    }

    @Override
    public void onActivating(ExecutableServiceTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onActivated(ExecutableServiceTask element, BpmnElementContext context) {
        long scopeKey = context.getElementInstanceKey();
        Either<Failure, String> jobTypeOrFailure = this.expressionBehavior.evaluateStringExpression(element.getType(), scopeKey);
        jobTypeOrFailure.flatMap(jobType -> this.expressionBehavior.evaluateLongExpression(element.getRetries(), scopeKey)).ifRightOrLeft(retries -> this.createNewJob(context, element, (String)jobTypeOrFailure.get(), retries.intValue()), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleting(ExecutableServiceTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).ifRightOrLeft(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            this.stateTransitionBehavior.transitionToCompleted(context);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleted(ExecutableServiceTask element, BpmnElementContext context) {
        this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onTerminating(ExecutableServiceTask element, BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        long jobKey = elementInstance.getJobKey();
        if (jobKey > 0L) {
            this.cancelJob(jobKey);
            this.incidentBehavior.resolveJobIncident(jobKey);
        }
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.stateTransitionBehavior.transitionToTerminated(context);
    }

    @Override
    public void onTerminated(ExecutableServiceTask element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.publishTriggeredBoundaryEvent(context);
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.onElementTerminated(element, context);
        this.stateBehavior.consumeToken(context);
        this.stateBehavior.removeElementInstance(context);
    }

    @Override
    public void onEventOccurred(ExecutableServiceTask element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.triggerBoundaryEvent(element, context);
    }

    private void createNewJob(BpmnElementContext context, ExecutableServiceTask serviceTask, String jobType, int retries) {
        this.jobCommand.setType(jobType).setRetries(retries).setCustomHeaders(serviceTask.getEncodedHeaders()).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(serviceTask.getId()).setElementInstanceKey(context.getElementInstanceKey());
        this.commandWriter.appendNewCommand((Intent)JobIntent.CREATE, (RecordValue)this.jobCommand);
    }

    private void cancelJob(long jobKey) {
        JobState.State state = this.stateBehavior.getJobState().getState(jobKey);
        if (state == JobState.State.ACTIVATABLE || state == JobState.State.ACTIVATED || state == JobState.State.FAILED) {
            JobRecord job = this.stateBehavior.getJobState().getJob(jobKey);
            this.commandWriter.appendFollowUpCommand(jobKey, (Intent)JobIntent.CANCEL, (RecordValue)job);
        }
    }
}

