/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.common;

import io.zeebe.engine.processing.common.EventHandle;
import io.zeebe.engine.processing.streamprocessor.writers.TypedEventWriter;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ErrorEventHandler {
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final EventHandle eventHandle;
    private final CatchEventAnalyzer stateAnalyzer;

    public ErrorEventHandler(ProcessState processState, ElementInstanceState elementInstanceState, MutableEventScopeInstanceState eventScopeInstanceState, KeyGenerator keyGenerator) {
        this.eventHandle = new EventHandle(keyGenerator, eventScopeInstanceState);
        this.stateAnalyzer = new CatchEventAnalyzer(processState, elementInstanceState);
    }

    public boolean throwErrorEvent(DirectBuffer errorCode, ElementInstance instance, TypedEventWriter eventWriter) {
        CatchEventAnalyzer.CatchEventTuple foundCatchEvent = this.stateAnalyzer.findCatchEvent(errorCode, instance);
        if (foundCatchEvent != null) {
            this.eventHandle.triggerEvent(eventWriter, foundCatchEvent.getElementInstance(), foundCatchEvent.getCatchEvent(), NO_VARIABLES);
            return true;
        }
        return false;
    }
}

