/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.common;

import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.processing.streamprocessor.writers.TypedEventWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

public final class EventHandle {
    private final ProcessInstanceRecord eventOccurredRecord = new ProcessInstanceRecord();
    private final KeyGenerator keyGenerator;
    private final MutableEventScopeInstanceState eventScopeInstanceState;

    public EventHandle(KeyGenerator keyGenerator, MutableEventScopeInstanceState eventScopeInstanceState) {
        this.keyGenerator = keyGenerator;
        this.eventScopeInstanceState = eventScopeInstanceState;
    }

    public boolean triggerEvent(TypedEventWriter eventWriter, ElementInstance eventScopeInstance, ExecutableFlowElement catchEvent, DirectBuffer variables) {
        if (eventScopeInstance == null || !eventScopeInstance.isActive()) {
            return false;
        }
        long newElementInstanceKey = this.keyGenerator.nextKey();
        boolean triggered = this.eventScopeInstanceState.triggerEvent(eventScopeInstance.getKey(), newElementInstanceKey, catchEvent.getId(), variables);
        if (triggered) {
            long eventOccurredKey;
            if (this.isEventSubprocess(catchEvent)) {
                eventOccurredKey = this.keyGenerator.nextKey();
                this.eventOccurredRecord.wrap(eventScopeInstance.getValue());
                this.eventOccurredRecord.setElementId(catchEvent.getId()).setBpmnElementType(BpmnElementType.START_EVENT).setFlowScopeKey(eventScopeInstance.getKey());
            } else {
                eventOccurredKey = eventScopeInstance.getKey();
                this.eventOccurredRecord.wrap(eventScopeInstance.getValue());
            }
            eventWriter.appendFollowUpEvent(eventOccurredKey, (Intent)ProcessInstanceIntent.EVENT_OCCURRED, (RecordValue)this.eventOccurredRecord);
        }
        return triggered;
    }

    public long triggerStartEvent(TypedStreamWriter streamWriter, long processDefinitionKey, DirectBuffer elementId, DirectBuffer variables) {
        long newElementInstanceKey = this.keyGenerator.nextKey();
        boolean triggered = this.eventScopeInstanceState.triggerEvent(processDefinitionKey, newElementInstanceKey, elementId, variables);
        if (triggered) {
            long processInstanceKey = this.keyGenerator.nextKey();
            this.activateStartEvent(streamWriter, processDefinitionKey, processInstanceKey, elementId);
            return processInstanceKey;
        }
        return -1L;
    }

    public void activateStartEvent(TypedStreamWriter streamWriter, long processDefinitionKey, long processInstanceKey, DirectBuffer elementId) {
        long eventOccurredKey = this.keyGenerator.nextKey();
        this.eventOccurredRecord.setBpmnElementType(BpmnElementType.START_EVENT).setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey).setElementId(elementId);
        streamWriter.appendFollowUpEvent(eventOccurredKey, (Intent)ProcessInstanceIntent.EVENT_OCCURRED, (RecordValue)this.eventOccurredRecord);
    }

    private boolean isEventSubprocess(ExecutableFlowElement catchEvent) {
        return catchEvent instanceof ExecutableStartEvent && ((ExecutableStartEvent)catchEvent).getEventSubProcess() != null;
    }
}

