/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment;

import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.state.deployment.DeployedProcess;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;

public class MessageStartEventSubscriptionManager {
    private final ProcessState processState;
    private final MessageStartEventSubscriptionRecord subscriptionRecord = new MessageStartEventSubscriptionRecord();

    public MessageStartEventSubscriptionManager(ProcessState processState) {
        this.processState = processState;
    }

    public void tryReOpenMessageStartEventSubscription(DeploymentRecord deploymentRecord, StateWriter stateWriter) {
        for (ProcessRecord processRecord : deploymentRecord.processes()) {
            if (!this.isLatestProcess(processRecord)) continue;
            this.closeExistingMessageStartEventSubscriptions(processRecord, stateWriter);
            this.openMessageStartEventSubscriptions(processRecord, stateWriter);
        }
    }

    private boolean isLatestProcess(ProcessRecord processRecord) {
        return this.processState.getLatestProcessVersionByProcessId(processRecord.getBpmnProcessIdBuffer()).getVersion() == processRecord.getVersion();
    }

    private void closeExistingMessageStartEventSubscriptions(ProcessRecord processRecord, StateWriter stateWriter) {
        DeployedProcess lastMsgProcess = this.findLastMessageStartProcess(processRecord);
        if (lastMsgProcess == null) {
            return;
        }
        this.subscriptionRecord.reset();
        this.subscriptionRecord.setProcessDefinitionKey(lastMsgProcess.getKey());
        stateWriter.appendFollowUpEvent(-1L, (Intent)MessageStartEventSubscriptionIntent.DELETED, (RecordValue)this.subscriptionRecord);
    }

    private DeployedProcess findLastMessageStartProcess(ProcessRecord processRecord) {
        for (int version = processRecord.getVersion() - 1; version > 0; --version) {
            DeployedProcess lastMsgProcess = this.processState.getProcessByProcessIdAndVersion(processRecord.getBpmnProcessIdBuffer(), version);
            if (lastMsgProcess == null || !lastMsgProcess.getProcess().getStartEvents().stream().anyMatch(ExecutableCatchEventElement::isMessage)) continue;
            return lastMsgProcess;
        }
        return null;
    }

    private void openMessageStartEventSubscriptions(ProcessRecord processRecord, StateWriter stateWriter) {
        long processDefinitionKey = processRecord.getKey();
        DeployedProcess processDefinition = this.processState.getProcessByKey(processDefinitionKey);
        ExecutableProcess process = processDefinition.getProcess();
        List<ExecutableStartEvent> startEvents = process.getStartEvents();
        for (ExecutableCatchEventElement executableCatchEventElement : startEvents) {
            if (!executableCatchEventElement.isMessage()) continue;
            ExecutableMessage message = executableCatchEventElement.getMessage();
            message.getMessageName().map(BufferUtil::wrapString).ifPresent(messageNameBuffer -> {
                this.subscriptionRecord.reset();
                this.subscriptionRecord.setMessageName(messageNameBuffer).setProcessDefinitionKey(processDefinitionKey).setBpmnProcessId(process.getId()).setStartEventId(startEvent.getId());
                stateWriter.appendFollowUpEvent(-1L, (Intent)MessageStartEventSubscriptionIntent.CREATED, (RecordValue)this.subscriptionRecord);
            });
        }
    }
}

