/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.distribute;

import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.DeploymentState;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentDistributionRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import java.util.function.Consumer;

public class CompleteDeploymentDistributionProcessor
implements TypedRecordProcessor<DeploymentDistributionRecord> {
    private static final String REJECT_MSG_DEPLOYMENT_DISTRIBUTION_COMPLETED = "Expected to find pending deployment with key %d, but deployment distribution already completed.";
    private final DeploymentRecord emptyDeploymentRecord = new DeploymentRecord();
    private final StateWriter stateWriter;
    private final DeploymentState deploymentState;
    private final TypedRejectionWriter rejectionWriter;

    public CompleteDeploymentDistributionProcessor(DeploymentState deploymentState, Writers writers) {
        this.stateWriter = writers.state();
        this.deploymentState = deploymentState;
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(long position, TypedRecord<DeploymentDistributionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        long deploymentKey = record.getKey();
        if (!this.deploymentState.hasPendingDeploymentDistribution(deploymentKey)) {
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(REJECT_MSG_DEPLOYMENT_DISTRIBUTION_COMPLETED, deploymentKey));
            return;
        }
        this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentDistributionIntent.COMPLETED, (RecordValue)record.getValue());
        if (!this.deploymentState.hasPendingDeploymentDistribution(deploymentKey)) {
            this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentIntent.FULLY_DISTRIBUTED, (RecordValue)this.emptyDeploymentRecord);
        }
    }
}

