/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.distribute;

import io.zeebe.engine.processing.deployment.DeploymentResponder;
import io.zeebe.engine.processing.deployment.MessageStartEventSubscriptionManager;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import java.util.function.Consumer;

public final class DeploymentDistributeProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private final MessageStartEventSubscriptionManager messageStartEventSubscriptionManager;
    private final DeploymentResponder deploymentResponder;
    private final int partitionId;
    private final StateWriter stateWriter;

    public DeploymentDistributeProcessor(ProcessState processState, DeploymentResponder deploymentResponder, int partitionId, Writers writers) {
        this.messageStartEventSubscriptionManager = new MessageStartEventSubscriptionManager(processState);
        this.deploymentResponder = deploymentResponder;
        this.partitionId = partitionId;
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(long position, TypedRecord<DeploymentRecord> event, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        DeploymentRecord deploymentEvent = event.getValue();
        long deploymentKey = event.getKey();
        this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentIntent.DISTRIBUTED, (RecordValue)deploymentEvent);
        this.deploymentResponder.sendDeploymentResponse(deploymentKey, this.partitionId);
        this.messageStartEventSubscriptionManager.tryReOpenMessageStartEventSubscription(deploymentEvent, this.stateWriter);
    }
}

