/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.distribute;

import io.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentDistributionRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.DirectBuffer;

public final class DeploymentDistributionBehavior {
    private final DeploymentDistributionRecord deploymentDistributionRecord = new DeploymentDistributionRecord();
    private final DeploymentRecord emptyDeploymentRecord = new DeploymentRecord();
    private final List<Integer> otherPartitions;
    private final DeploymentDistributor deploymentDistributor;
    private final ActorControl processingActor;
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;

    public DeploymentDistributionBehavior(Writers writers, int partitionsCount, DeploymentDistributor deploymentDistributor, ActorControl processingActor) {
        this.otherPartitions = IntStream.range(1, 1 + partitionsCount).filter(partition -> partition != 1).boxed().collect(Collectors.toList());
        this.deploymentDistributor = deploymentDistributor;
        this.processingActor = processingActor;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
    }

    public void distributeDeployment(DeploymentRecord deploymentEvent, long key) {
        DirectBuffer copiedDeploymentBuffer = BufferUtil.createCopy((BufferWriter)deploymentEvent);
        this.otherPartitions.forEach(partitionId -> {
            this.deploymentDistributionRecord.setPartition(partitionId.intValue());
            this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentDistributionIntent.DISTRIBUTING, (RecordValue)this.deploymentDistributionRecord);
            this.distributeDeploymentToPartition((int)partitionId, key, copiedDeploymentBuffer);
        });
        if (this.otherPartitions.isEmpty()) {
            this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentIntent.FULLY_DISTRIBUTED, (RecordValue)this.emptyDeploymentRecord);
        }
    }

    public void distributeDeploymentToPartition(int partitionId, long key, DirectBuffer copiedDeploymentBuffer) {
        ActorFuture<Void> deploymentPushedFuture = this.deploymentDistributor.pushDeploymentToPartition(key, partitionId, copiedDeploymentBuffer);
        deploymentPushedFuture.onComplete((v, t) -> this.processingActor.runUntilDone(() -> {
            this.deploymentDistributionRecord.setPartition(partitionId);
            this.commandWriter.reset();
            this.commandWriter.appendFollowUpCommand(key, (Intent)DeploymentDistributionIntent.COMPLETE, (RecordValue)this.deploymentDistributionRecord);
            long pos = this.commandWriter.flush();
            if (pos < 0L) {
                this.processingActor.yield();
            } else {
                this.processingActor.done();
            }
        }));
    }
}

