/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.distribute;

import io.zeebe.engine.processing.deployment.distribute.DeploymentDistributionBehavior;
import io.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.DeploymentState;
import io.zeebe.util.sched.ActorControl;

public class DeploymentRedistributor
implements StreamProcessorLifecycleAware {
    private final int partitionsCount;
    private final DeploymentDistributor deploymentDistributor;
    private final DeploymentState deploymentState;

    public DeploymentRedistributor(int partitionsCount, DeploymentDistributor deploymentDistributor, DeploymentState deploymentState) {
        this.partitionsCount = partitionsCount;
        this.deploymentDistributor = deploymentDistributor;
        this.deploymentState = deploymentState;
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext context) {
        ActorControl actor = context.getActor();
        Writers writers = context.getWriters();
        DeploymentDistributionBehavior deploymentDistributionBehavior = new DeploymentDistributionBehavior(writers, this.partitionsCount, this.deploymentDistributor, actor);
        this.deploymentState.foreachPendingDeploymentDistribution((key, partitionId, deployment) -> deploymentDistributionBehavior.distributeDeploymentToPartition(partitionId, key, deployment));
    }
}

