/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.element;

import io.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.buffer.BufferUtil;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;

public class ExecutableProcess
extends ExecutableFlowElementContainer {
    private final Map<DirectBuffer, AbstractFlowElement> flowElements = new HashMap<DirectBuffer, AbstractFlowElement>();

    public ExecutableProcess(String id) {
        super(id);
        this.addFlowElement(this);
    }

    public void addFlowElement(AbstractFlowElement element) {
        this.flowElements.put(element.getId(), element);
    }

    public AbstractFlowElement getElementById(DirectBuffer id) {
        return this.flowElements.get(id);
    }

    public <T extends ExecutableFlowElement> T getElementById(String id, Class<T> expectedType) {
        return this.getElementById(BufferUtil.wrapString((String)id), expectedType);
    }

    public <T extends ExecutableFlowElement> T getElementById(DirectBuffer id, Class<T> expectedClass) {
        BpmnElementType elementType = ExecutableMultiInstanceBody.class.isAssignableFrom(expectedClass) ? BpmnElementType.MULTI_INSTANCE_BODY : BpmnElementType.UNSPECIFIED;
        return this.getElementById(id, elementType, expectedClass);
    }

    public <T extends ExecutableFlowElement> T getElementById(DirectBuffer id, BpmnElementType elementType, Class<T> expectedClass) {
        AbstractFlowElement element = this.flowElements.get(id);
        if (element == null) {
            return null;
        }
        if (element instanceof ExecutableMultiInstanceBody && elementType != BpmnElementType.MULTI_INSTANCE_BODY) {
            ExecutableMultiInstanceBody multiInstanceBody = (ExecutableMultiInstanceBody)element;
            element = multiInstanceBody.getInnerActivity();
        }
        if (element.getElementType() != elementType && elementType != BpmnElementType.UNSPECIFIED) {
            throw new RuntimeException(String.format("Expected element with id '%s' to be of type '%s', but it is of type '%s'", BufferUtil.bufferAsString((DirectBuffer)id), elementType, element.getElementType()));
        }
        if (expectedClass.isAssignableFrom(element.getClass())) {
            return (T)element;
        }
        throw new RuntimeException(String.format("Expected element with id '%s' to be instance of class '%s', but it is an instance of '%s'", BufferUtil.bufferAsString((DirectBuffer)id), expectedClass.getSimpleName(), element.getClass().getSimpleName()));
    }
}

