/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.transformation;

import io.zeebe.el.ExpressionLanguage;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.zeebe.engine.processing.deployment.model.transformation.TransformationVisitor;
import io.zeebe.engine.processing.deployment.model.transformer.BoundaryEventTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.CallActivityTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.CatchEventTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.ContextProcessTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.EndEventTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.ErrorTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.EventBasedGatewayTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.ExclusiveGatewayTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.FlowElementInstantiationTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.FlowNodeTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.IntermediateCatchEventTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.MessageTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.MultiInstanceActivityTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.ProcessTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.ReceiveTaskTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.SequenceFlowTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.ServiceTaskTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.StartEventTransformer;
import io.zeebe.engine.processing.deployment.model.transformer.SubProcessTransformer;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.traversal.ModelElementVisitor;
import io.zeebe.model.bpmn.traversal.ModelWalker;
import java.util.List;

public final class BpmnTransformer {
    private final TransformationVisitor step1Visitor;
    private final TransformationVisitor step2Visitor;
    private final TransformationVisitor step3Visitor;
    private final TransformationVisitor step4Visitor;
    private final ExpressionLanguage expressionLanguage;

    public BpmnTransformer(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
        this.step1Visitor = new TransformationVisitor();
        this.step1Visitor.registerHandler(new ErrorTransformer());
        this.step1Visitor.registerHandler(new FlowElementInstantiationTransformer());
        this.step1Visitor.registerHandler(new MessageTransformer());
        this.step1Visitor.registerHandler(new ProcessTransformer());
        this.step2Visitor = new TransformationVisitor();
        this.step2Visitor.registerHandler(new BoundaryEventTransformer());
        this.step2Visitor.registerHandler(new CallActivityTransformer());
        this.step2Visitor.registerHandler(new CatchEventTransformer());
        this.step2Visitor.registerHandler(new ContextProcessTransformer());
        this.step2Visitor.registerHandler(new EndEventTransformer());
        this.step2Visitor.registerHandler(new FlowNodeTransformer());
        this.step2Visitor.registerHandler(new SequenceFlowTransformer());
        this.step2Visitor.registerHandler(new ServiceTaskTransformer());
        this.step2Visitor.registerHandler(new ReceiveTaskTransformer());
        this.step2Visitor.registerHandler(new StartEventTransformer());
        this.step3Visitor = new TransformationVisitor();
        this.step3Visitor.registerHandler(new ContextProcessTransformer());
        this.step3Visitor.registerHandler(new EventBasedGatewayTransformer());
        this.step3Visitor.registerHandler(new ExclusiveGatewayTransformer());
        this.step3Visitor.registerHandler(new IntermediateCatchEventTransformer());
        this.step3Visitor.registerHandler(new SubProcessTransformer());
        this.step4Visitor = new TransformationVisitor();
        this.step4Visitor.registerHandler(new MultiInstanceActivityTransformer());
    }

    public List<ExecutableProcess> transformDefinitions(BpmnModelInstance modelInstance) {
        TransformContext context = new TransformContext();
        context.setExpressionLanguage(this.expressionLanguage);
        ModelWalker walker = new ModelWalker(modelInstance);
        this.step1Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step1Visitor);
        this.step2Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step2Visitor);
        this.step3Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step3Visitor);
        this.step4Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step4Visitor);
        return context.getProcesses();
    }
}

