/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.transformer;

import io.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.EndEvent;
import io.zeebe.model.bpmn.instance.Error;
import io.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.zeebe.model.bpmn.instance.EventDefinition;

public final class EndEventTransformer
implements ModelElementTransformer<EndEvent> {
    @Override
    public Class<EndEvent> getType() {
        return EndEvent.class;
    }

    @Override
    public void transform(EndEvent element, TransformContext context) {
        ExecutableProcess currentProcess = context.getCurrentProcess();
        ExecutableEndEvent endEvent = currentProcess.getElementById(element.getId(), ExecutableEndEvent.class);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, endEvent);
        }
    }

    private void transformEventDefinition(EndEvent element, TransformContext context, ExecutableEndEvent executableElement) {
        EventDefinition eventDefinition = (EventDefinition)element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof ErrorEventDefinition) {
            this.transformErrorEventDefinition(context, executableElement, (ErrorEventDefinition)eventDefinition);
        }
    }

    private void transformErrorEventDefinition(TransformContext context, ExecutableEndEvent executableElement, ErrorEventDefinition errorEventDefinition) {
        Error error = errorEventDefinition.getError();
        ExecutableError executableError = context.getError(error.getId());
        executableElement.setError(executableError);
    }
}

