/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.transformer;

import io.zeebe.el.EvaluationResult;
import io.zeebe.el.Expression;
import io.zeebe.el.ExpressionLanguage;
import io.zeebe.el.ResultType;
import io.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.ExtensionElements;
import io.zeebe.model.bpmn.instance.Message;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeSubscription;

public final class MessageTransformer
implements ModelElementTransformer<Message> {
    @Override
    public Class<Message> getType() {
        return Message.class;
    }

    @Override
    public void transform(Message element, TransformContext context) {
        String id = element.getId();
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        ExecutableMessage executableElement = new ExecutableMessage(id);
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements != null) {
            ZeebeSubscription subscription = (ZeebeSubscription)extensionElements.getElementsQuery().filterByType(ZeebeSubscription.class).singleResult();
            Expression correlationKeyExpression = expressionLanguage.parseExpression(subscription.getCorrelationKey());
            executableElement.setCorrelationKeyExpression(correlationKeyExpression);
        }
        if (element.getName() != null) {
            EvaluationResult messageNameResult;
            Expression messageNameExpression = expressionLanguage.parseExpression(element.getName());
            executableElement.setMessageNameExpression(messageNameExpression);
            if (messageNameExpression.isStatic() && (messageNameResult = expressionLanguage.evaluateExpression(messageNameExpression, variable -> null)).getType() == ResultType.STRING) {
                String messageName = messageNameResult.getString();
                executableElement.setMessageName(messageName);
            }
            context.addMessage(executableElement);
        }
    }
}

