/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.transformer;

import io.zeebe.el.Expression;
import io.zeebe.el.ExpressionLanguage;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.ConditionExpression;
import io.zeebe.model.bpmn.instance.SequenceFlow;

public final class SequenceFlowTransformer
implements ModelElementTransformer<SequenceFlow> {
    @Override
    public Class<SequenceFlow> getType() {
        return SequenceFlow.class;
    }

    @Override
    public void transform(SequenceFlow element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableSequenceFlow sequenceFlow = process.getElementById(element.getId(), ExecutableSequenceFlow.class);
        this.parseCondition(element, sequenceFlow, context.getExpressionLanguage());
        this.connectWithFlowNodes(element, process, sequenceFlow);
    }

    private void connectWithFlowNodes(SequenceFlow element, ExecutableProcess process, ExecutableSequenceFlow sequenceFlow) {
        ExecutableFlowNode source = process.getElementById(element.getSource().getId(), ExecutableFlowNode.class);
        ExecutableFlowNode target = process.getElementById(element.getTarget().getId(), ExecutableFlowNode.class);
        source.addOutgoing(sequenceFlow);
        target.addIncoming(sequenceFlow);
        sequenceFlow.setTarget(target);
        sequenceFlow.setSource(source);
    }

    private void parseCondition(SequenceFlow element, ExecutableSequenceFlow sequenceFlow, ExpressionLanguage expressionLanguage) {
        ConditionExpression conditionExpression = element.getConditionExpression();
        if (conditionExpression != null) {
            String condition = conditionExpression.getTextContent();
            Expression parsedCondition = expressionLanguage.parseExpression(condition);
            sequenceFlow.setCondition(parsedCondition);
        }
    }
}

