/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.transformer;

import io.zeebe.el.EvaluationResult;
import io.zeebe.el.ExpressionLanguage;
import io.zeebe.el.ResultType;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.FlowNode;
import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.model.bpmn.instance.StartEvent;

public final class StartEventTransformer
implements ModelElementTransformer<StartEvent> {
    @Override
    public Class<StartEvent> getType() {
        return StartEvent.class;
    }

    @Override
    public void transform(StartEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableStartEvent startEvent = process.getElementById(element.getId(), ExecutableStartEvent.class);
        startEvent.setInterrupting(element.isInterrupting());
        if (element.getScope() instanceof FlowNode) {
            FlowNode scope = (FlowNode)element.getScope();
            ExecutableFlowElementContainer subprocess = process.getElementById(scope.getId(), ExecutableFlowElementContainer.class);
            subprocess.addStartEvent(startEvent);
        } else {
            process.addStartEvent(startEvent);
        }
        if (startEvent.isMessage() && element.getScope() instanceof Process) {
            this.evaluateMessageNameExpression(startEvent, context);
        }
    }

    private void evaluateMessageNameExpression(ExecutableStartEvent startEvent, TransformContext context) {
        ExecutableMessage message = startEvent.getMessage();
        if (message.getMessageName().isEmpty()) {
            ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
            EvaluationResult messageNameResult = expressionLanguage.evaluateExpression(message.getMessageNameExpression(), variable -> null);
            if (messageNameResult.isFailure()) {
                throw new IllegalStateException(String.format("Error while evaluating '%s': %s", message.getMessageNameExpression(), messageNameResult.getFailureMessage()));
            }
            if (messageNameResult.getType() == ResultType.STRING) {
                String messageName = messageNameResult.getString();
                message.setMessageName(messageName);
            } else {
                throw new IllegalStateException(String.format("Expected FEEL expression or static value of '%s' of type STRING, but was: %s", messageNameResult.getExpression(), messageNameResult.getType().name()));
            }
        }
    }
}

