/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.transformer;

import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.FlowNode;
import io.zeebe.model.bpmn.instance.SubProcess;

public final class SubProcessTransformer
implements ModelElementTransformer<SubProcess> {
    @Override
    public Class<SubProcess> getType() {
        return SubProcess.class;
    }

    @Override
    public void transform(SubProcess element, TransformContext context) {
        ExecutableProcess currentProcess = context.getCurrentProcess();
        ExecutableFlowElementContainer subprocess = currentProcess.getElementById(element.getId(), ExecutableFlowElementContainer.class);
        if (element.triggeredByEvent()) {
            this.transformEventSubprocess(element, currentProcess, subprocess);
        }
    }

    private void transformEventSubprocess(SubProcess element, ExecutableProcess currentProcess, ExecutableFlowElementContainer subprocess) {
        if (element.getScope() instanceof FlowNode) {
            FlowNode scope = (FlowNode)element.getScope();
            ExecutableFlowElementContainer parentSubProc = currentProcess.getElementById(scope.getId(), ExecutableFlowElementContainer.class);
            parentSubProc.attach(subprocess);
        } else {
            currentProcess.attach(subprocess);
        }
        ExecutableStartEvent startEvent = subprocess.getStartEvents().iterator().next();
        startEvent.setEventSubProcess(subprocess.getId());
    }
}

