/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.model.validation;

import io.zeebe.el.Expression;
import io.zeebe.el.ExpressionLanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class ZeebeExpressionValidator<T extends ModelElementInstance>
implements ModelElementValidator<T> {
    private static final Pattern PATH_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*(\\.[a-zA-Z][a-zA-Z0-9_]*)*");
    private static final List<String> PATH_RESERVED_WORDS = List.of("null", "true", "false", "function", "if", "then", "else", "for", "between", "instance", "of");
    private final ExpressionLanguage expressionLanguage;
    private final Class<T> elementType;
    private final List<Verification<T>> verifications;

    private ZeebeExpressionValidator(ExpressionLanguage expressionLanguage, Class<T> elementType, List<Verification<T>> verifications) {
        this.expressionLanguage = expressionLanguage;
        this.elementType = elementType;
        this.verifications = verifications;
    }

    public Class<T> getElementType() {
        return this.elementType;
    }

    public void validate(T element, ValidationResultCollector validationResultCollector) {
        this.verifications.forEach(verification -> {
            String expression = verification.expressionSupplier.apply((ModelElementInstance)element);
            verification.assertion.verify(expression, this.expressionLanguage, validationResultCollector);
        });
    }

    public static <T extends ModelElementInstance> Builder<T> verifyThat(Class<T> elementType) {
        return new Builder<T>(elementType);
    }

    private static void verifyPath(String expression, ExpressionLanguage expressionLanguage, ValidationResultCollector resultCollector) {
        boolean isReservedWord;
        if (expression == null || expression.isEmpty()) {
            resultCollector.addError(0, "Expected path expression but not found.");
            return;
        }
        Matcher matcher = PATH_PATTERN.matcher(expression);
        if (!matcher.matches()) {
            resultCollector.addError(0, String.format("Expected path expression '%s' but doesn't match the pattern '%s'.", expression, PATH_PATTERN));
        }
        if (isReservedWord = PATH_RESERVED_WORDS.contains(expression)) {
            resultCollector.addError(0, String.format("Expected path expression '%s' but is one of the reserved words (%s).", expression, String.join((CharSequence)", ", PATH_RESERVED_WORDS)));
        }
    }

    @FunctionalInterface
    private static interface Assertion {
        public void verify(String var1, ExpressionLanguage var2, ValidationResultCollector var3);
    }

    private static final class Verification<T> {
        private final Function<T, String> expressionSupplier;
        private final Assertion assertion;

        private Verification(Function<T, String> expressionSupplier, Assertion assertion) {
            this.expressionSupplier = expressionSupplier;
            this.assertion = assertion;
        }
    }

    public static final class ExpressionVerification {
        private boolean isNonStatic = false;
        private boolean isMandatory = false;

        public ExpressionVerification isNonStatic() {
            this.isNonStatic = true;
            return this;
        }

        public ExpressionVerification isMandatory() {
            this.isMandatory = true;
            return this;
        }

        public ExpressionVerification isOptional() {
            this.isMandatory = false;
            return this;
        }

        private Assertion build() {
            return (expression, expressionLanguage, resultCollector) -> {
                if (expression == null) {
                    if (this.isMandatory) {
                        resultCollector.addError(0, "Expected expression but not found.");
                    }
                    return;
                }
                Expression parseResult = expressionLanguage.parseExpression(expression);
                if (!parseResult.isValid()) {
                    resultCollector.addError(0, parseResult.getFailureMessage());
                    return;
                }
                if (parseResult.isStatic() && this.isNonStatic) {
                    resultCollector.addError(0, String.format("Expected expression but found static value '%s'. An expression must start with '=' (e.g. '=%s').", expression, expression));
                }
            };
        }
    }

    public static class Builder<T extends ModelElementInstance> {
        private final Class<T> elementType;
        private final List<Verification<T>> verifications = new ArrayList<Verification<T>>();

        public Builder(Class<T> elementType) {
            this.elementType = elementType;
        }

        public Builder<T> hasValidExpression(Function<T, String> expressionSupplier, Consumer<ExpressionVerification> expressionVerification) {
            ExpressionVerification expressionV = new ExpressionVerification();
            expressionVerification.accept(expressionV);
            this.verifications.add(new Verification<T>(expressionSupplier, expressionV.build()));
            return this;
        }

        public Builder<T> hasValidPath(Function<T, String> expressionSupplier) {
            this.verifications.add(new Verification<T>(expressionSupplier, (x$0, x$1, x$2) -> ZeebeExpressionValidator.verifyPath(x$0, x$1, x$2)));
            return this;
        }

        public ZeebeExpressionValidator<T> build(ExpressionLanguage expressionLanguage) {
            return new ZeebeExpressionValidator<T>(expressionLanguage, this.elementType, this.verifications);
        }
    }
}

