/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.deployment.transform;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.zeebe.engine.processing.deployment.transform.BpmnValidator;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.deployment.DeployedProcess;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.immutable.ZeebeState;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;
import org.slf4j.Logger;

public final class DeploymentTransformer {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final BpmnValidator validator;
    private final ProcessState processState;
    private final KeyGenerator keyGenerator;
    private final MessageDigest digestGenerator;
    private final Map<String, String> processIdToResourceName = new HashMap<String, String>();
    private RejectionType rejectionType;
    private String rejectionReason;
    private final StateWriter stateWriter;

    public DeploymentTransformer(StateWriter stateWriter, ZeebeState zeebeState, ExpressionProcessor expressionProcessor, KeyGenerator keyGenerator) {
        this.stateWriter = stateWriter;
        this.processState = zeebeState.getProcessState();
        this.keyGenerator = keyGenerator;
        this.validator = BpmnFactory.createValidator(expressionProcessor);
        try {
            this.digestGenerator = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean transform(DeploymentRecord deploymentEvent) {
        StringBuilder errors = new StringBuilder();
        boolean success = true;
        this.processIdToResourceName.clear();
        Iterator resourceIterator = deploymentEvent.resources().iterator();
        if (!resourceIterator.hasNext()) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = "Expected to deploy at least one resource, but none given";
            return false;
        }
        while (resourceIterator.hasNext()) {
            DeploymentResource deploymentResource = (DeploymentResource)resourceIterator.next();
            success &= this.transformResource(deploymentEvent, errors, deploymentResource);
        }
        if (!success) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = String.format("Expected to deploy new resources, but encountered the following errors:%s", errors.toString());
        }
        return success;
    }

    private boolean transformResource(DeploymentRecord deploymentEvent, StringBuilder errors, DeploymentResource deploymentResource) {
        boolean success = false;
        String resourceName = deploymentResource.getResourceName();
        try {
            BpmnModelInstance definition = this.readProcessDefinition(deploymentResource);
            String validationError = this.validator.validate(definition);
            if (validationError == null) {
                BpmnFactory.createTransformer().transformDefinitions(definition);
                String bpmnIdDuplicateError = this.checkForDuplicateBpmnId(definition, resourceName);
                if (bpmnIdDuplicateError == null) {
                    this.transformProcessResource(deploymentEvent, deploymentResource, definition);
                    success = true;
                } else {
                    errors.append("\n").append(bpmnIdDuplicateError);
                }
            } else {
                errors.append("\n'").append(resourceName).append("': ").append(validationError);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected error while processing resource '{}'", (Object)resourceName, (Object)e);
            errors.append("\n'").append(resourceName).append("': ").append(e.getMessage());
        }
        return success;
    }

    private String checkForDuplicateBpmnId(BpmnModelInstance model, String currentResource) {
        Collection processes = model.getDefinitions().getChildElementsByType(Process.class);
        for (Process process : processes) {
            String previousResource = this.processIdToResourceName.get(process.getId());
            if (previousResource != null) {
                return String.format("Duplicated process id in resources '%s' and '%s'", previousResource, currentResource);
            }
            this.processIdToResourceName.put(process.getId(), currentResource);
        }
        return null;
    }

    private void transformProcessResource(DeploymentRecord deploymentEvent, DeploymentResource deploymentResource, BpmnModelInstance definition) {
        Collection processes = definition.getDefinitions().getChildElementsByType(Process.class);
        for (Process process : processes) {
            if (!process.isExecutable()) continue;
            String bpmnProcessId = process.getId();
            DeployedProcess lastProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)bpmnProcessId));
            DirectBuffer lastDigest = this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)bpmnProcessId));
            UnsafeBuffer resourceDigest = new UnsafeBuffer(this.digestGenerator.digest(deploymentResource.getResource()));
            ProcessRecord processRecord = (ProcessRecord)deploymentEvent.processes().add();
            processRecord.setBpmnProcessId(BufferUtil.wrapString((String)process.getId())).setChecksum((DirectBuffer)resourceDigest).setResourceName(deploymentResource.getResourceNameBuffer()).setResource(deploymentResource.getResourceBuffer());
            boolean isDuplicate = this.isDuplicateOfLatest(deploymentResource, (DirectBuffer)resourceDigest, lastProcess, lastDigest);
            if (isDuplicate) {
                processRecord.setVersion(lastProcess.getVersion()).setKey(lastProcess.getKey());
                continue;
            }
            long key = this.keyGenerator.nextKey();
            processRecord.setKey(key).setVersion(this.processState.getProcessVersion(bpmnProcessId) + 1);
            this.stateWriter.appendFollowUpEvent(key, (Intent)ProcessIntent.CREATED, (RecordValue)processRecord);
        }
    }

    private boolean isDuplicateOfLatest(DeploymentResource deploymentResource, DirectBuffer resourceDigest, DeployedProcess lastProcess, DirectBuffer lastVersionDigest) {
        return lastVersionDigest != null && lastProcess != null && lastVersionDigest.equals(resourceDigest) && lastProcess.getResourceName().equals(deploymentResource.getResourceNameBuffer());
    }

    private BpmnModelInstance readProcessDefinition(DeploymentResource deploymentResource) {
        DirectBuffer resource = deploymentResource.getResourceBuffer();
        DirectBufferInputStream resourceStream = new DirectBufferInputStream(resource);
        return Bpmn.readModelFromStream((InputStream)resourceStream);
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }
}

