/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.incident;

import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.state.immutable.IncidentState;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.value.ErrorType;

public final class CreateIncidentProcessor
implements CommandProcessor<IncidentRecord> {
    private static final String INVALID_JOB_STATE_MESSAGE = "Expected to create incident for failed job with key '%d', but it is in state '%s'";
    private static final String NO_FAILED_JOB_MESSAGE = "Expected to create incident for failed job with key '%d', but no such job was found";
    private final JobState jobState;
    private final IncidentState incidentState;

    public CreateIncidentProcessor(MutableZeebeState zeebeState) {
        this.jobState = zeebeState.getJobState();
        this.incidentState = zeebeState.getIncidentState();
    }

    @Override
    public boolean onCommand(TypedRecord<IncidentRecord> command, CommandProcessor.CommandControl<IncidentRecord> commandControl) {
        boolean incidentIsNotRejected;
        IncidentRecord incidentEvent = command.getValue();
        boolean bl = incidentIsNotRejected = !this.tryRejectIncidentCreation(incidentEvent, commandControl, command);
        if (incidentIsNotRejected) {
            commandControl.accept((Intent)IncidentIntent.CREATED, incidentEvent);
        }
        return true;
    }

    public boolean tryRejectIncidentCreation(IncidentRecord incidentEvent, CommandProcessor.CommandControl<IncidentRecord> commandControl, TypedRecord<IncidentRecord> command) {
        boolean isJobIncident = this.incidentState.isJobIncident(incidentEvent);
        if (isJobIncident) {
            return this.tryRejectJobIncident(incidentEvent.getJobKey(), commandControl, command);
        }
        return false;
    }

    private boolean tryRejectJobIncident(long jobKey, CommandProcessor.CommandControl<IncidentRecord> commandControl, TypedRecord<IncidentRecord> command) {
        JobState.State currentJobState = this.jobState.getState(jobKey);
        if (currentJobState == JobState.State.NOT_FOUND) {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_FAILED_JOB_MESSAGE, jobKey));
            return true;
        }
        if (currentJobState == JobState.State.ACTIVATABLE && ErrorType.MESSAGE_SIZE_EXCEEDED == command.getValue().getErrorType()) {
            return false;
        }
        if (currentJobState != JobState.State.FAILED && currentJobState != JobState.State.ERROR_THROWN) {
            commandControl.reject(RejectionType.INVALID_STATE, String.format(INVALID_JOB_STATE_MESSAGE, new Object[]{jobKey, currentJobState}));
            return true;
        }
        return false;
    }
}

