/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.incident;

import io.zeebe.engine.processing.incident.IncidentRecordWrapper;
import io.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.zeebe.engine.processing.streamprocessor.writers.NoopResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.immutable.IncidentState;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.util.Either;
import java.util.function.Consumer;

public final class ResolveIncidentProcessor
implements TypedRecordProcessor<IncidentRecord> {
    public static final String NO_INCIDENT_FOUND_MSG = "Expected to resolve incident with key '%d', but no such incident was found";
    private static final String RESOLVE_UNHANDLED_ERROR_INCIDENT_MESSAGE = "Expected to resolve incident of unhandled error for job %d, but such incidents cannot be resolved. See issue #6000";
    private static final String ELEMENT_NOT_IN_SUPPORTED_STATE_MSG = "Expected incident to refer to element in state ELEMENT_ACTIVATING or ELEMENT_COMPLETING, but element is in state %s";
    private final ProcessInstanceRecord failedRecord = new ProcessInstanceRecord();
    private final SideEffectQueue sideEffects = new SideEffectQueue();
    private final TypedResponseWriter noopResponseWriter = new NoopResponseWriter();
    private final TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final IncidentState incidentState;
    private final ElementInstanceState elementInstanceState;
    private final JobState jobState;

    public ResolveIncidentProcessor(MutableZeebeState zeebeState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, Writers writers) {
        this.bpmnStreamProcessor = bpmnStreamProcessor;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.incidentState = zeebeState.getIncidentState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.jobState = zeebeState.getJobState();
    }

    @Override
    public void processRecord(TypedRecord<IncidentRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        long incidentKey = command.getKey();
        IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(incidentKey);
        if (incidentRecord == null) {
            String errorMessage = String.format(NO_INCIDENT_FOUND_MSG, incidentKey);
            this.rejectResolveCommand(command, responseWriter, errorMessage, RejectionType.NOT_FOUND);
            return;
        }
        this.stateWriter.appendFollowUpEvent(incidentKey, (Intent)IncidentIntent.RESOLVED, (RecordValue)incidentRecord);
        responseWriter.writeEventOnCommand(incidentKey, (Intent)IncidentIntent.RESOLVED, (UnpackedObject)incidentRecord, command);
        this.attemptToResolveIncident(command, responseWriter, streamWriter, sideEffect, incidentRecord);
    }

    private void rejectResolveCommand(TypedRecord<IncidentRecord> command, TypedResponseWriter responseWriter, String errorMessage, RejectionType rejectionType) {
        this.rejectionWriter.appendRejection(command, rejectionType, errorMessage);
        responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, errorMessage);
    }

    private void attemptToResolveIncident(TypedRecord<IncidentRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect, IncidentRecord incidentRecord) {
        boolean isJobIncident;
        long jobKey = incidentRecord.getJobKey();
        boolean bl = isJobIncident = jobKey > 0L;
        if (isJobIncident) {
            JobState.State stateOfJob = this.jobState.getState(jobKey);
            if (stateOfJob == JobState.State.ERROR_THROWN) {
                String message = String.format(RESOLVE_UNHANDLED_ERROR_INCIDENT_MESSAGE, jobKey);
                this.rejectResolveCommand(command, responseWriter, message, RejectionType.PROCESSING_ERROR);
            }
        } else {
            this.attemptToContinueProcessProcessing(command, responseWriter, streamWriter, sideEffect, incidentRecord);
        }
    }

    private void attemptToContinueProcessProcessing(TypedRecord<IncidentRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect, IncidentRecord incidentRecord) {
        this.getFailedCommand(incidentRecord).ifRightOrLeft(failedCommand -> {
            this.sideEffects.clear();
            this.sideEffects.add(responseWriter::flush);
            this.bpmnStreamProcessor.processRecord((TypedRecord<ProcessInstanceRecord>)failedCommand, this.noopResponseWriter, streamWriter, this.sideEffects::add);
            sideEffect.accept(this.sideEffects);
        }, failure -> this.rejectResolveCommand(command, responseWriter, (String)failure, RejectionType.NOT_FOUND));
    }

    private Either<String, TypedRecord<ProcessInstanceRecord>> getFailedCommand(IncidentRecord incidentRecord) {
        long elementInstanceKey = incidentRecord.getElementInstanceKey();
        ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (elementInstance == null) {
            return Either.left((Object)String.format("Expected to resolve incident with element instance %d, but element instance not found", elementInstanceKey));
        }
        return this.getFailedCommandIntent(elementInstance).map(commandIntent -> {
            this.failedRecord.wrap(elementInstance.getValue());
            return new IncidentRecordWrapper(elementInstanceKey, (ProcessInstanceIntent)commandIntent, this.failedRecord);
        });
    }

    private Either<String, ProcessInstanceIntent> getFailedCommandIntent(ElementInstance elementInstance) {
        ProcessInstanceIntent instanceState = elementInstance.getState();
        if (!MigratedStreamProcessors.isMigrated(elementInstance.getValue().getBpmnElementType())) {
            return Either.right((Object)instanceState);
        }
        switch (instanceState) {
            case ELEMENT_ACTIVATING: {
                return Either.right((Object)ProcessInstanceIntent.ACTIVATE_ELEMENT);
            }
            case ELEMENT_COMPLETING: {
                return Either.right((Object)ProcessInstanceIntent.COMPLETE_ELEMENT);
            }
        }
        return Either.left((Object)String.format(ELEMENT_NOT_IN_SUPPORTED_STATE_MSG, instanceState));
    }
}

