/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.job;

import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import java.util.function.BiConsumer;

final class DefaultJobCommandPreconditionGuard<J extends JobRecord> {
    private static final String NO_JOB_FOUND_MESSAGE = "Expected to %s job with key '%d', but no such job was found";
    private static final String INVALID_JOB_STATE_MESSAGE = "Expected to %s job with key '%d', but it is in state '%s'";
    private final String intent;
    private final JobState state;
    private final BiConsumer<TypedRecord<J>, CommandProcessor.CommandControl<J>> acceptCommand;

    public DefaultJobCommandPreconditionGuard(String intent, JobState state, BiConsumer<TypedRecord<J>, CommandProcessor.CommandControl<J>> acceptCommand) {
        this.intent = intent;
        this.state = state;
        this.acceptCommand = acceptCommand;
    }

    public boolean onCommand(TypedRecord<J> command, CommandProcessor.CommandControl<J> commandControl) {
        long jobKey = command.getKey();
        JobState.State jobState = this.state.getState(jobKey);
        if (jobState == JobState.State.ACTIVATABLE || jobState == JobState.State.ACTIVATED) {
            this.acceptCommand.accept(command, commandControl);
        } else if (jobState == JobState.State.NOT_FOUND) {
            String message = String.format(NO_JOB_FOUND_MESSAGE, this.intent, jobKey);
            commandControl.reject(RejectionType.NOT_FOUND, message);
        } else {
            String message = String.format(INVALID_JOB_STATE_MESSAGE, new Object[]{this.intent, jobKey, jobState});
            commandControl.reject(RejectionType.INVALID_STATE, message);
        }
        return true;
    }
}

