/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.job;

import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.immutable.ZeebeState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public final class JobCancelProcessor
implements CommandProcessor<JobRecord> {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to cancel job with key '%d', but no such job was found";
    private final JobState jobState;

    public JobCancelProcessor(ZeebeState state) {
        this.jobState = state.getJobState();
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        if (job != null) {
            commandControl.accept((Intent)JobIntent.CANCELED, job);
        } else {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, jobKey));
        }
        return true;
    }
}

