/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.job;

import io.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedEventWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.immutable.ZeebeState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;

public final class JobCompleteProcessor
implements CommandProcessor<JobRecord> {
    private final JobState jobState;
    private final ElementInstanceState elementInstanceState;
    private final DefaultJobCommandPreconditionGuard<JobRecord> defaultProcessor;
    private final TypedEventWriter eventWriter;

    public JobCompleteProcessor(ZeebeState state, Writers writers) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("complete", this.jobState, this::acceptCommand);
        this.eventWriter = writers.events();
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.defaultProcessor.onCommand(command, commandControl);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, JobRecord value) {
        long scopeKey;
        ElementInstance scopeInstance;
        long serviceTaskKey = value.getElementInstanceKey();
        ElementInstance serviceTask = this.elementInstanceState.getInstance(serviceTaskKey);
        if (serviceTask != null && (scopeInstance = this.elementInstanceState.getInstance(scopeKey = serviceTask.getValue().getFlowScopeKey())) != null && scopeInstance.isActive()) {
            ProcessInstanceRecord processInstanceRecord = serviceTask.getValue();
            if (MigratedStreamProcessors.isMigrated(BpmnElementType.SERVICE_TASK)) {
                stateWriter.appendFollowUpEvent(serviceTaskKey, (Intent)ProcessInstanceIntent.ELEMENT_COMPLETING, (RecordValue)processInstanceRecord);
            } else {
                this.eventWriter.appendFollowUpEvent(serviceTaskKey, (Intent)ProcessInstanceIntent.ELEMENT_COMPLETING, (RecordValue)processInstanceRecord);
            }
        }
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        job.setVariables(command.getValue().getVariablesBuffer());
        commandControl.accept((Intent)JobIntent.COMPLETED, job);
    }
}

