/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.job;

import io.zeebe.engine.processing.job.CreateProcessor;
import io.zeebe.engine.processing.job.JobBatchActivateProcessor;
import io.zeebe.engine.processing.job.JobCancelProcessor;
import io.zeebe.engine.processing.job.JobCompleteProcessor;
import io.zeebe.engine.processing.job.JobFailProcessor;
import io.zeebe.engine.processing.job.JobThrowErrorProcessor;
import io.zeebe.engine.processing.job.JobTimeOutProcessor;
import io.zeebe.engine.processing.job.JobTimeoutTrigger;
import io.zeebe.engine.processing.job.JobUpdateRetriesProcessor;
import io.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.mutable.MutableJobState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobBatchIntent;
import io.zeebe.protocol.record.intent.JobIntent;
import java.util.function.Consumer;

public final class JobEventProcessors {
    public static void addJobProcessors(TypedRecordProcessors typedRecordProcessors, MutableZeebeState zeebeState, final Consumer<String> onJobsAvailableCallback, int maxRecordSize, Writers writers) {
        final MutableJobState jobState = zeebeState.getJobState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        typedRecordProcessors.onCommand(ValueType.JOB, (Intent)JobIntent.CREATE, new CreateProcessor()).onCommand(ValueType.JOB, (Intent)JobIntent.COMPLETE, new JobCompleteProcessor(zeebeState, writers)).onCommand(ValueType.JOB, (Intent)JobIntent.FAIL, new JobFailProcessor(zeebeState)).onCommand(ValueType.JOB, (Intent)JobIntent.THROW_ERROR, new JobThrowErrorProcessor(zeebeState, keyGenerator)).onCommand(ValueType.JOB, (Intent)JobIntent.TIME_OUT, new JobTimeOutProcessor(zeebeState)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE_RETRIES, new JobUpdateRetriesProcessor(zeebeState)).onCommand(ValueType.JOB, (Intent)JobIntent.CANCEL, new JobCancelProcessor(zeebeState)).onCommand(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE, new JobBatchActivateProcessor(writers, zeebeState, maxRecordSize)).withListener(new JobTimeoutTrigger(jobState)).withListener(new StreamProcessorLifecycleAware(){

            @Override
            public void onRecovered(ReadonlyProcessingContext context) {
                jobState.setJobsAvailableCallback(onJobsAvailableCallback);
            }
        });
    }
}

