/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.job;

import io.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.immutable.ZeebeState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.value.ErrorType;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class JobFailProcessor
implements CommandProcessor<JobRecord> {
    private static final DirectBuffer DEFAULT_ERROR_MESSAGE = BufferUtil.wrapString((String)"No more retries left.");
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private final JobState jobState;
    private final DefaultJobCommandPreconditionGuard<JobRecord> defaultProcessor;

    public JobFailProcessor(ZeebeState state) {
        this.jobState = state.getJobState();
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("fail", this.jobState, this::acceptCommand);
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.defaultProcessor.onCommand(command, commandControl);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, JobRecord value) {
        if (value.getRetries() <= 0) {
            DirectBuffer jobErrorMessage = value.getErrorMessageBuffer();
            DirectBuffer incidentErrorMessage = DEFAULT_ERROR_MESSAGE;
            if (jobErrorMessage.capacity() > 0) {
                incidentErrorMessage = jobErrorMessage;
            }
            this.incidentEvent.reset();
            this.incidentEvent.setErrorType(ErrorType.JOB_NO_RETRIES).setErrorMessage(incidentErrorMessage).setBpmnProcessId(value.getBpmnProcessIdBuffer()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setElementId(value.getElementIdBuffer()).setElementInstanceKey(value.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(value.getElementInstanceKey());
            commandWriter.appendNewCommand((Intent)IncidentIntent.CREATE, (RecordValue)this.incidentEvent);
        }
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long key = command.getKey();
        JobRecord failedJob = this.jobState.getJob(key);
        failedJob.setRetries(command.getValue().getRetries());
        failedJob.setErrorMessage(command.getValue().getErrorMessageBuffer());
        commandControl.accept((Intent)JobIntent.FAILED, failedJob);
    }
}

