/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.job;

import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.immutable.ZeebeState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public final class JobTimeOutProcessor
implements CommandProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to time out activated job with key '%d', but %s";
    private final JobState jobState;

    public JobTimeOutProcessor(ZeebeState state) {
        this.jobState = state.getJobState();
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATED) {
            commandControl.accept((Intent)JobIntent.TIMED_OUT, command.getValue());
        } else {
            String textState;
            switch (state) {
                case ACTIVATABLE: {
                    textState = "it must be activated first";
                    break;
                }
                case FAILED: {
                    textState = "it is marked as failed";
                    break;
                }
                default: {
                    textState = "no such job was found";
                }
            }
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NOT_ACTIVATED_JOB_MESSAGE, jobKey, textState));
        }
        return true;
    }
}

