/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.common.EventHandle;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.message.PendingProcessInstanceSubscriptionChecker;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.message.ProcessInstanceSubscription;
import io.zeebe.engine.state.mutable.MutableProcessInstanceSubscriptionState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.message.ProcessInstanceSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.sched.ActorControl;
import java.time.Duration;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class CorrelateProcessInstanceSubscription
implements TypedRecordProcessor<ProcessInstanceSubscriptionRecord> {
    private static final Duration SUBSCRIPTION_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration SUBSCRIPTION_CHECK_INTERVAL = Duration.ofSeconds(30L);
    private static final String NO_EVENT_OCCURRED_MESSAGE = "Expected to correlate a process instance subscription with element key '%d' and message name '%s', but the subscription is not active anymore";
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to correlate process instance subscription with element key '%d' and message name '%s', but no such subscription was found";
    private static final String ALREADY_CLOSING_MESSAGE = "Expected to correlate process instance subscription with element key '%d' and message name '%s', but it is already closing";
    private final MutableProcessInstanceSubscriptionState subscriptionState;
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;
    private final KeyGenerator keyGenerator;
    private final EventHandle eventHandle;
    private final ProcessInstanceRecord eventSubprocessRecord = new ProcessInstanceRecord();
    private ProcessInstanceSubscriptionRecord subscriptionRecord;
    private DirectBuffer correlationKey;

    public CorrelateProcessInstanceSubscription(MutableProcessInstanceSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, MutableZeebeState zeebeState) {
        this.subscriptionState = subscriptionState;
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.processState = zeebeState.getProcessState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.keyGenerator = zeebeState.getKeyGenerator();
        this.eventHandle = new EventHandle(this.keyGenerator, zeebeState.getEventScopeInstanceState());
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        ActorControl actor = processingContext.getActor();
        PendingProcessInstanceSubscriptionChecker pendingSubscriptionChecker = new PendingProcessInstanceSubscriptionChecker(this.subscriptionCommandSender, this.subscriptionState, SUBSCRIPTION_TIMEOUT.toMillis());
        actor.runAtFixedRate(SUBSCRIPTION_CHECK_INTERVAL, (Runnable)pendingSubscriptionChecker);
    }

    @Override
    public void onClose() {
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        boolean isTriggered;
        this.subscriptionRecord = record.getValue();
        long elementInstanceKey = this.subscriptionRecord.getElementInstanceKey();
        ProcessInstanceSubscription subscription = this.subscriptionState.getSubscription(elementInstanceKey, this.subscriptionRecord.getMessageNameBuffer());
        if (subscription == null || subscription.isClosing()) {
            RejectionType type = RejectionType.NOT_FOUND;
            String reason = NO_SUBSCRIPTION_FOUND_MESSAGE;
            if (subscription != null) {
                type = RejectionType.INVALID_STATE;
                reason = ALREADY_CLOSING_MESSAGE;
                this.correlationKey = subscription.getCorrelationKey();
            } else {
                this.correlationKey = this.subscriptionRecord.getCorrelationKeyBuffer();
            }
            sideEffect.accept(this::sendRejectionCommand);
            streamWriter.appendRejection(record, type, String.format(reason, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
            return;
        }
        if (subscription.shouldCloseOnCorrelate()) {
            this.subscriptionState.remove(subscription);
        }
        if (isTriggered = this.triggerCatchEvent(streamWriter, subscription, record.getValue().getVariablesBuffer())) {
            sideEffect.accept(this::sendAcknowledgeCommand);
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)ProcessInstanceSubscriptionIntent.CORRELATED, (RecordValue)this.subscriptionRecord);
        } else {
            this.correlationKey = subscription.getCorrelationKey();
            sideEffect.accept(this::sendRejectionCommand);
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(NO_EVENT_OCCURRED_MESSAGE, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
        }
    }

    private boolean triggerCatchEvent(TypedStreamWriter streamWriter, ProcessInstanceSubscription subscription, DirectBuffer variables) {
        ElementInstance elementInstance = this.elementInstanceState.getInstance(subscription.getElementInstanceKey());
        if (elementInstance == null) {
            return false;
        }
        long processDefinitionKey = elementInstance.getValue().getProcessDefinitionKey();
        ExecutableFlowElement catchEvent = this.processState.getFlowElement(processDefinitionKey, subscription.getTargetElementId(), ExecutableFlowElement.class);
        return this.eventHandle.triggerEvent(streamWriter, elementInstance, catchEvent, variables);
    }

    private boolean sendAcknowledgeCommand() {
        return this.subscriptionCommandSender.correlateMessageSubscription(this.subscriptionRecord.getSubscriptionPartitionId(), this.subscriptionRecord.getProcessInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getBpmnProcessIdBuffer(), this.subscriptionRecord.getMessageNameBuffer());
    }

    private boolean sendRejectionCommand() {
        return this.subscriptionCommandSender.rejectCorrelateMessageSubscription(this.subscriptionRecord.getProcessInstanceKey(), this.subscriptionRecord.getBpmnProcessIdBuffer(), this.subscriptionRecord.getMessageKey(), this.subscriptionRecord.getMessageNameBuffer(), this.correlationKey);
    }
}

