/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.state.immutable.MessageState;
import io.zeebe.engine.state.message.StoredMessage;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.function.Consumer;
import org.agrona.collections.MutableBoolean;

public final class MessageCorrelator {
    private final MessageState messageState;
    private final SubscriptionCommandSender commandSender;
    private final StateWriter stateWriter;
    private Consumer<SideEffectProducer> sideEffect;

    public MessageCorrelator(MessageState messageState, SubscriptionCommandSender commandSender, StateWriter stateWriter) {
        this.messageState = messageState;
        this.commandSender = commandSender;
        this.stateWriter = stateWriter;
    }

    public boolean correlateNextMessage(long subscriptionKey, MessageSubscriptionRecord subscriptionRecord, Consumer<SideEffectProducer> sideEffect) {
        this.sideEffect = sideEffect;
        MutableBoolean isMessageCorrelated = new MutableBoolean(false);
        this.messageState.visitMessages(subscriptionRecord.getMessageNameBuffer(), subscriptionRecord.getCorrelationKeyBuffer(), storedMessage -> {
            boolean isCorrelated = this.correlateMessage(subscriptionKey, subscriptionRecord, storedMessage);
            isMessageCorrelated.set(isCorrelated);
            return !isCorrelated;
        });
        return isMessageCorrelated.get();
    }

    private boolean correlateMessage(long subscriptionKey, MessageSubscriptionRecord subscriptionRecord, StoredMessage storedMessage) {
        boolean correlateMessage;
        long messageKey = storedMessage.getMessageKey();
        MessageRecord message = storedMessage.getMessage();
        boolean bl = correlateMessage = message.getDeadline() > ActorClock.currentTimeMillis() && !this.messageState.existMessageCorrelation(messageKey, subscriptionRecord.getBpmnProcessIdBuffer());
        if (correlateMessage) {
            subscriptionRecord.setMessageKey(messageKey).setVariables(message.getVariablesBuffer());
            this.stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)MessageSubscriptionIntent.CORRELATING, (RecordValue)subscriptionRecord);
            this.sideEffect.accept(() -> this.sendCorrelateCommand(subscriptionRecord));
        }
        return correlateMessage;
    }

    private boolean sendCorrelateCommand(MessageSubscriptionRecord subscriptionRecord) {
        return this.commandSender.correlateProcessInstanceSubscription(subscriptionRecord.getProcessInstanceKey(), subscriptionRecord.getElementInstanceKey(), subscriptionRecord.getBpmnProcessIdBuffer(), subscriptionRecord.getMessageNameBuffer(), subscriptionRecord.getMessageKey(), subscriptionRecord.getVariablesBuffer(), subscriptionRecord.getCorrelationKeyBuffer());
    }
}

