/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.MessageExpireProcessor;
import io.zeebe.engine.processing.message.MessageObserver;
import io.zeebe.engine.processing.message.MessagePublishProcessor;
import io.zeebe.engine.processing.message.MessageSubscriptionCorrelateProcessor;
import io.zeebe.engine.processing.message.MessageSubscriptionCreateProcessor;
import io.zeebe.engine.processing.message.MessageSubscriptionDeleteProcessor;
import io.zeebe.engine.processing.message.MessageSubscriptionRejectProcessor;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.zeebe.engine.state.mutable.MutableMessageState;
import io.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;

public final class MessageEventProcessors {
    public static void addMessageProcessors(TypedRecordProcessors typedRecordProcessors, MutableZeebeState zeebeState, SubscriptionCommandSender subscriptionCommandSender, Writers writers) {
        MutableMessageState messageState = zeebeState.getMessageState();
        MutableMessageSubscriptionState subscriptionState = zeebeState.getMessageSubscriptionState();
        MutableMessageStartEventSubscriptionState startEventSubscriptionState = zeebeState.getMessageStartEventSubscriptionState();
        MutableEventScopeInstanceState eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        typedRecordProcessors.onCommand(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH, new MessagePublishProcessor(messageState, subscriptionState, startEventSubscriptionState, eventScopeInstanceState, subscriptionCommandSender, keyGenerator, writers)).onCommand(ValueType.MESSAGE, (Intent)MessageIntent.EXPIRE, new MessageExpireProcessor(writers.state())).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CREATE, new MessageSubscriptionCreateProcessor(messageState, subscriptionState, subscriptionCommandSender, writers, keyGenerator)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, new MessageSubscriptionCorrelateProcessor(messageState, subscriptionState, subscriptionCommandSender, writers)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.DELETE, new MessageSubscriptionDeleteProcessor(subscriptionState, subscriptionCommandSender, writers)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, new MessageSubscriptionRejectProcessor(messageState, subscriptionState, subscriptionCommandSender, writers)).withListener(new MessageObserver(messageState, subscriptionState, subscriptionCommandSender));
    }
}

