/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.MessageTimeToLiveChecker;
import io.zeebe.engine.processing.message.PendingMessageSubscriptionChecker;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.zeebe.engine.state.immutable.MessageState;
import io.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.zeebe.util.sched.ActorControl;
import java.time.Duration;

public final class MessageObserver
implements StreamProcessorLifecycleAware {
    public static final Duration MESSAGE_TIME_TO_LIVE_CHECK_INTERVAL = Duration.ofSeconds(60L);
    public static final Duration SUBSCRIPTION_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration SUBSCRIPTION_CHECK_INTERVAL = Duration.ofSeconds(30L);
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final MessageState messageState;
    private final MutableMessageSubscriptionState subscriptionState;

    public MessageObserver(MessageState messageState, MutableMessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender) {
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.messageState = messageState;
        this.subscriptionState = subscriptionState;
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext context) {
        ActorControl actor = context.getActor();
        MessageTimeToLiveChecker timeToLiveChecker = new MessageTimeToLiveChecker(context.getLogStreamWriter(), this.messageState);
        context.getActor().runAtFixedRate(MESSAGE_TIME_TO_LIVE_CHECK_INTERVAL, (Runnable)timeToLiveChecker);
        PendingMessageSubscriptionChecker pendingSubscriptionChecker = new PendingMessageSubscriptionChecker(this.subscriptionCommandSender, this.subscriptionState, SUBSCRIPTION_TIMEOUT.toMillis());
        actor.runAtFixedRate(SUBSCRIPTION_CHECK_INTERVAL, (Runnable)pendingSubscriptionChecker);
    }
}

