/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.common.EventHandle;
import io.zeebe.engine.processing.message.Subscriptions;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.zeebe.engine.state.immutable.MessageState;
import io.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableMessageState;
import io.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class MessagePublishProcessor
implements TypedRecordProcessor<MessageRecord> {
    private static final String ALREADY_PUBLISHED_MESSAGE = "Expected to publish a new message with id '%s', but a message with that id was already published";
    private final MessageState messageState;
    private final MessageSubscriptionState subscriptionState;
    private final MessageStartEventSubscriptionState startEventSubscriptionState;
    private final SubscriptionCommandSender commandSender;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final EventHandle eventHandle;
    private final Subscriptions correlatingSubscriptions = new Subscriptions();
    private TypedResponseWriter responseWriter;
    private MessageRecord messageRecord;
    private long messageKey;

    public MessagePublishProcessor(MutableMessageState messageState, MutableMessageSubscriptionState subscriptionState, MessageStartEventSubscriptionState startEventSubscriptionState, MutableEventScopeInstanceState eventScopeInstanceState, SubscriptionCommandSender commandSender, KeyGenerator keyGenerator, Writers writers) {
        this.messageState = messageState;
        this.subscriptionState = subscriptionState;
        this.startEventSubscriptionState = startEventSubscriptionState;
        this.commandSender = commandSender;
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.eventHandle = new EventHandle(keyGenerator, eventScopeInstanceState);
    }

    @Override
    public void processRecord(TypedRecord<MessageRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.responseWriter = responseWriter;
        this.messageRecord = command.getValue();
        this.correlatingSubscriptions.clear();
        if (this.messageRecord.hasMessageId() && this.messageState.exist(this.messageRecord.getNameBuffer(), this.messageRecord.getCorrelationKeyBuffer(), this.messageRecord.getMessageIdBuffer())) {
            String rejectionReason = String.format(ALREADY_PUBLISHED_MESSAGE, BufferUtil.bufferAsString((DirectBuffer)this.messageRecord.getMessageIdBuffer()));
            streamWriter.appendRejection(command, RejectionType.ALREADY_EXISTS, rejectionReason);
            responseWriter.writeRejectionOnCommand(command, RejectionType.ALREADY_EXISTS, rejectionReason);
        } else {
            this.handleNewMessage(command, responseWriter, streamWriter, sideEffect);
        }
    }

    private void handleNewMessage(TypedRecord<MessageRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.messageKey = this.keyGenerator.nextKey();
        this.messageRecord.setDeadline(command.getTimestamp() + this.messageRecord.getTimeToLive());
        this.stateWriter.appendFollowUpEvent(this.messageKey, (Intent)MessageIntent.PUBLISHED, (RecordValue)command.getValue());
        responseWriter.writeEventOnCommand(this.messageKey, (Intent)MessageIntent.PUBLISHED, (UnpackedObject)command.getValue(), command);
        this.correlateToSubscriptions(this.messageKey, this.messageRecord);
        this.correlateToMessageStartEvents(this.messageRecord, streamWriter);
        sideEffect.accept(this::sendCorrelateCommand);
        if (this.messageRecord.getTimeToLive() <= 0L) {
            this.stateWriter.appendFollowUpEvent(this.messageKey, (Intent)MessageIntent.EXPIRED, (RecordValue)this.messageRecord);
        }
    }

    private void correlateToSubscriptions(long messageKey, MessageRecord message) {
        this.subscriptionState.visitSubscriptions(message.getNameBuffer(), message.getCorrelationKeyBuffer(), subscription -> {
            if (!subscription.isCorrelating() && !this.correlatingSubscriptions.contains(subscription.getRecord().getBpmnProcessIdBuffer())) {
                MessageSubscriptionRecord correlatingSubscription = subscription.getRecord().setMessageKey(messageKey).setVariables(message.getVariablesBuffer());
                this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)MessageSubscriptionIntent.CORRELATING, (RecordValue)correlatingSubscription);
                this.correlatingSubscriptions.add(correlatingSubscription);
            }
            return true;
        });
    }

    private void correlateToMessageStartEvents(MessageRecord messageRecord, TypedStreamWriter streamWriter) {
        this.startEventSubscriptionState.visitSubscriptionsByMessageName(messageRecord.getNameBuffer(), subscription -> {
            DirectBuffer bpmnProcessIdBuffer = subscription.getBpmnProcessIdBuffer();
            DirectBuffer correlationKeyBuffer = messageRecord.getCorrelationKeyBuffer();
            if (!(this.correlatingSubscriptions.contains(bpmnProcessIdBuffer) || correlationKeyBuffer.capacity() != 0 && this.messageState.existActiveProcessInstance(bpmnProcessIdBuffer, correlationKeyBuffer))) {
                this.correlatingSubscriptions.add((MessageStartEventSubscriptionRecord)subscription);
                long processInstanceKey = this.keyGenerator.nextKey();
                subscription.setProcessInstanceKey(processInstanceKey).setCorrelationKey(correlationKeyBuffer).setMessageKey(this.messageKey).setVariables(messageRecord.getVariablesBuffer());
                this.stateWriter.appendFollowUpEvent(-1L, (Intent)MessageStartEventSubscriptionIntent.CORRELATED, (RecordValue)subscription);
                this.eventHandle.activateStartEvent(streamWriter, subscription.getProcessDefinitionKey(), processInstanceKey, subscription.getStartEventIdBuffer());
            }
        });
    }

    private boolean sendCorrelateCommand() {
        boolean success = this.correlatingSubscriptions.visitSubscriptions(subscription -> this.commandSender.correlateProcessInstanceSubscription(subscription.getProcessInstanceKey(), subscription.getElementInstanceKey(), subscription.getBpmnProcessId(), this.messageRecord.getNameBuffer(), this.messageKey, this.messageRecord.getVariablesBuffer(), this.messageRecord.getCorrelationKeyBuffer()));
        return success && this.responseWriter.flush();
    }
}

