/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.MessageCorrelator;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.MessageState;
import io.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class MessageSubscriptionCorrelateProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to correlate subscription for element with key '%d' and message name '%s', but no such message subscription exists";
    private final MessageSubscriptionState subscriptionState;
    private final MessageCorrelator messageCorrelator;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;

    public MessageSubscriptionCorrelateProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.messageCorrelator = new MessageCorrelator(messageState, commandSender, this.stateWriter);
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        MessageSubscriptionRecord command = record.getValue();
        MessageSubscription subscription = this.subscriptionState.get(command.getElementInstanceKey(), command.getMessageNameBuffer());
        if (subscription == null) {
            this.rejectCommand(record);
            return;
        }
        MessageSubscriptionRecord messageSubscription = subscription.getRecord();
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)MessageSubscriptionIntent.CORRELATED, (RecordValue)messageSubscription);
        if (!messageSubscription.isInterrupting()) {
            this.messageCorrelator.correlateNextMessage(subscription.getKey(), messageSubscription, sideEffect);
        }
    }

    private void rejectCommand(TypedRecord<MessageSubscriptionRecord> record) {
        MessageSubscriptionRecord subscription = record.getValue();
        String reason = String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, subscription.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)subscription.getMessageNameBuffer()));
        this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, reason);
    }
}

